/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.findings.FindingsDescriptionOverrideCache;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.Nullable;

public class ConfigurationTemplate {
    private static final Comparator<QualityIndicatorTemplate> QUALITY_INDICATOR_COMPARATOR = Comparator.comparing(QualityIndicatorTemplate::getName);
    @JsonIgnore
    private final Map<String, QualityIndicatorTemplate> qualityIndicatorsByName = new HashMap<String, QualityIndicatorTemplate>();
    @JsonProperty(value="qualityIndicators")
    private final List<QualityIndicatorTemplate> qualityIndicators = new ArrayList<QualityIndicatorTemplate>();
    @JsonIgnore
    private final Map<String, AnalysisGroupDescriptor> analysisGroupsByName = new HashMap<String, AnalysisGroupDescriptor>();
    @JsonProperty(value="analysisGroups")
    private final List<AnalysisGroupDescriptor> analysisGroups = new ArrayList<AnalysisGroupDescriptor>();
    @JsonIgnore
    private final Map<String, ConfigOptionDescriptorBase> globalOptionsByName = new HashMap<String, ConfigOptionDescriptorBase>();
    @JsonProperty(value="globalOptions")
    private final List<ConfigOptionDescriptorBase> globalOptions = new ArrayList<ConfigOptionDescriptorBase>();
    @JsonIgnore
    private final Map<String, ConfigOptionDescriptorBase> qualityIndicatorOptionsByName = new HashMap<String, ConfigOptionDescriptorBase>();
    @JsonProperty(value="qualityIndicatorOptions")
    private final List<ConfigOptionDescriptorBase> qualityIndicatorOptions = new ArrayList<ConfigOptionDescriptorBase>();
    @JsonIgnore
    private final Map<Class<? extends AnalysisConfigurationBase>, AnalysisConfigurationBase> allConfigurations;
    @JsonIgnore
    private final @Nullable CodeScopeName codeScopeName;
    @JsonIgnore
    private final Set<ELanguage> languages;

    public ConfigurationTemplate(@Nullable CodeScopeName codeScopeName, @Nullable ConfigurationTemplateManager templateManager, Set<ELanguage> languages) {
        this.codeScopeName = codeScopeName;
        this.allConfigurations = templateManager != null ? templateManager.getAllConfigurations() : new HashMap<Class<? extends AnalysisConfigurationBase>, AnalysisConfigurationBase>();
        this.languages = languages;
    }

    public void registerConfigurationItems(String analysisGroupName, String qualityIndicatorName, Collection<ConfigurationItemBase> configurationItems) {
        this.registerConfigurationItems(analysisGroupName, qualityIndicatorName, configurationItems, false);
    }

    public void registerConfigurationItems(String analysisGroupName, @Nullable String qualityIndicatorName, Collection<ConfigurationItemBase> configurationItems, boolean insertAtStart) {
        CCSMAssert.isNotEmpty(configurationItems, (String)("At least one configuration item expected for analysis group " + analysisGroupName + " in quality indicator " + qualityIndicatorName));
        AnalysisGroupDescriptor analysisGroupDescriptor = this.analysisGroupsByName.get(analysisGroupName);
        if (analysisGroupDescriptor == null) {
            analysisGroupDescriptor = new AnalysisGroupDescriptor(analysisGroupName, configurationItems.toArray(new ConfigurationItemBase[0]));
            this.registerAnalysisGroup(analysisGroupDescriptor);
            if (analysisGroupDescriptor.isActive() && qualityIndicatorName != null) {
                this.getOrCreateQualityIndicatorTemplate(qualityIndicatorName).addGroup(analysisGroupDescriptor);
            }
        } else {
            for (QualityIndicatorTemplate qualityIndicator : this.qualityIndicators) {
                CCSMAssert.isFalse((qualityIndicator.getGroupNames().contains((Object)analysisGroupName) && !qualityIndicator.getName().equals(qualityIndicatorName) ? 1 : 0) != 0, (String)("Analysis group " + analysisGroupName + " to be registered for quality indicator " + qualityIndicatorName + " was registered before for " + qualityIndicator.getName()));
            }
            boolean wasActive = analysisGroupDescriptor.isActive();
            if (insertAtStart) {
                for (ConfigurationItemBase item : CollectionUtils.reverse(configurationItems)) {
                    analysisGroupDescriptor.insert(item, 0);
                }
            } else {
                for (ConfigurationItemBase item : configurationItems) {
                    analysisGroupDescriptor.add(item);
                }
            }
            if (!wasActive && analysisGroupDescriptor.isActive() && qualityIndicatorName != null) {
                this.getOrCreateQualityIndicatorTemplate(qualityIndicatorName).addGroup(analysisGroupDescriptor);
            }
            this.collectConfigurations(analysisGroupDescriptor);
        }
    }

    public void registerConfigurationItemsCodeScopeAware(String analysisGroupName, String qualityIndicatorName, Collection<ConfigurationItemBase> configurationItems) {
        configurationItems.forEach(ConfigurationItemBase::declareCodeScopeAware);
        this.registerConfigurationItems(analysisGroupName, qualityIndicatorName, configurationItems);
    }

    public void registerAnalysisGroup(AnalysisGroupDescriptor analysisGroupDescriptor) {
        String name = analysisGroupDescriptor.getName();
        CCSMAssert.isFalse((boolean)this.analysisGroupsByName.containsKey(name), (String)("Duplicate analysis group name: " + name));
        this.analysisGroupsByName.put(name, analysisGroupDescriptor);
        this.analysisGroups.add(analysisGroupDescriptor);
        this.collectConfigurations(analysisGroupDescriptor);
        analysisGroupDescriptor.setRegistered();
    }

    public void registerQualityIndicatorTemplate(QualityIndicatorTemplate qualityIndicatorTemplate) {
        String name = qualityIndicatorTemplate.getName();
        CCSMAssert.isFalse((boolean)this.qualityIndicatorsByName.containsKey(name), (String)("Duplicate quality indicator name: " + name));
        this.qualityIndicatorsByName.put(name, qualityIndicatorTemplate);
        this.qualityIndicators.add(qualityIndicatorTemplate);
        this.qualityIndicators.sort(QUALITY_INDICATOR_COMPARATOR);
    }

    public void removeQualityIndicatorTemplates(Collection<String> qualityIndicatorTemplateNames) {
        IdentityHashSet qualityIndicatorsToRemove = new IdentityHashSet();
        for (String qualityIndicatorTemplateName : qualityIndicatorTemplateNames) {
            QualityIndicatorTemplate qualityIndicatorTemplate = this.qualityIndicatorsByName.get(qualityIndicatorTemplateName);
            CCSMAssert.isNotNull((Object)qualityIndicatorTemplate, (String)("Quality indicator " + qualityIndicatorTemplateName + " not found!"));
            qualityIndicatorsToRemove.add(qualityIndicatorTemplate);
            this.qualityIndicatorOptionsByName.remove(qualityIndicatorTemplateName);
        }
        IdentityHashSet newQualityIndicators = new IdentityHashSet(this.qualityIndicators);
        newQualityIndicators.removeAll((Collection<?>)qualityIndicatorsToRemove);
        this.qualityIndicators.clear();
        this.qualityIndicators.addAll((Collection<QualityIndicatorTemplate>)newQualityIndicators);
        this.qualityIndicators.sort(QUALITY_INDICATOR_COMPARATOR);
    }

    public QualityIndicatorTemplate getOrCreateQualityIndicatorTemplate(String qualityIndicatorName) {
        QualityIndicatorTemplate qualityIndicator = this.qualityIndicatorsByName.get(qualityIndicatorName);
        if (qualityIndicator == null) {
            qualityIndicator = new QualityIndicatorTemplate(qualityIndicatorName, this.languages, new AnalysisGroupDescriptor[0]);
            this.registerQualityIndicatorTemplate(qualityIndicator);
        }
        return qualityIndicator;
    }

    public QualityIndicatorTemplate getQualityIndicator(String name) {
        return this.qualityIndicatorsByName.get(name);
    }

    public UnmodifiableList<QualityIndicatorTemplate> getQualityIndicators() {
        return CollectionUtils.asUnmodifiable(this.qualityIndicators);
    }

    public @Nullable AnalysisGroupDescriptor getAnalysisGroup(String name) {
        return this.analysisGroupsByName.get(name);
    }

    public UnmodifiableList<AnalysisGroupDescriptor> getAnalysisGroups() {
        return CollectionUtils.asUnmodifiable(this.analysisGroups);
    }

    private void collectConfigurations(AnalysisGroupDescriptor group) {
        try {
            for (AnalysisConfigurationBase configuration : group.getReferencedConfigurations(EnumSet.allOf(EAnalysisTool.class))) {
                this.registerConfiguration(configuration);
            }
        }
        catch (ProjectConfigurationException e) {
            CCSMAssert.fail((String)e.getMessage());
        }
    }

    public void registerConfiguration(AnalysisConfigurationBase configuration) {
        AnalysisConfigurationBase oldEntry = this.allConfigurations.put(configuration.getClass(), configuration);
        CCSMAssert.isTrue((oldEntry == null || oldEntry == configuration ? 1 : 0) != 0, (String)("Had different configurations for class " + String.valueOf(configuration.getClass())));
    }

    public void registerGlobalOption(ConfigOptionDescriptorBase option) {
        this.registerOption(option, "global option", this.globalOptionsByName, this.globalOptions);
    }

    public void registerGlobalOptionCodeScopeAware(ConfigOptionDescriptorBase option) {
        option.declareCodeScopeAware();
        this.registerGlobalOption(option);
    }

    public List<ConfigOptionDescriptorBase> getGlobalOptions() {
        return this.globalOptions;
    }

    public void registerQualityIndicatorOption(ConfigOptionDescriptorBase option) {
        this.registerOption(option, "quality indicator option", this.qualityIndicatorOptionsByName, this.qualityIndicatorOptions);
    }

    public List<ConfigOptionDescriptorBase> getQualityIndicatorOptions() {
        return this.qualityIndicatorOptions;
    }

    private void registerOption(ConfigOptionDescriptorBase option, String optionTypeName, Map<String, ConfigOptionDescriptorBase> optionsByName, List<ConfigOptionDescriptorBase> options) {
        String name = option.getName();
        CCSMAssert.isFalse((boolean)optionsByName.containsKey(name), (String)("Duplicate " + optionTypeName + " name: " + name));
        optionsByName.put(option.getName(), option);
        options.add(option);
        CCSMAssert.isInstanceOf((Object)option.getConfiguration(), AnalysisConfigurationBase.class);
        this.registerConfiguration((AnalysisConfigurationBase)option.getConfiguration());
    }

    public @Nullable ConfigOptionDescriptorBase getGlobalOption(String name) {
        return this.globalOptionsByName.get(name);
    }

    public @Nullable ConfigOptionDescriptorBase getQualityIndicatorOption(String name) {
        return this.qualityIndicatorOptionsByName.get(name);
    }

    public void removeEmptyGroups() {
        HashSet<String> namesOfGroupsToRemove = new HashSet<String>();
        for (AnalysisGroupDescriptor group2 : this.analysisGroups) {
            if (!group2.getConfigurationItems().isEmpty()) continue;
            namesOfGroupsToRemove.add(group2.getName());
        }
        if (namesOfGroupsToRemove.isEmpty()) {
            return;
        }
        this.analysisGroups.removeIf(group -> namesOfGroupsToRemove.contains(group.getName()));
        this.analysisGroupsByName.keySet().removeAll(namesOfGroupsToRemove);
        for (QualityIndicatorTemplate indicator : this.qualityIndicators) {
            indicator.removeGroups(namesOfGroupsToRemove);
        }
    }

    public void adjustFindingDescriptionsWithOverrideCache(SynchronizedCacheAccess<FindingsDescriptionOverrideCache> cacheAccess) throws StorageException {
        Set availableDescriptions = (Set)cacheAccess.getOrUpdate(FindingsDescriptionOverrideCache::getAllCacheKeys);
        for (AnalysisGroupDescriptor group : this.analysisGroups) {
            List findingsWithCustomDescription = CollectionUtils.filter(group.getConfigurationItems(), item -> item instanceof FindingDescriptor && availableDescriptions.contains(Pair.createPair((Object)((Object)((FindingDescriptor)item).getTool()), (Object)FileSystemUtils.toValidFileName((String)((FindingDescriptor)item).getReadableName()))));
            for (ConfigurationItemBase match : findingsWithCustomDescription) {
                FindingDescriptor description = (FindingDescriptor)cacheAccess.getOrUpdate(cache -> cache.adjustDescription((FindingDescriptor)match));
                group.replaceItem(match, description);
            }
        }
    }

    public @Nullable CodeScopeName getCodeScope() {
        return this.codeScopeName;
    }
}

