/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import java.io.Serializable;
import java.util.Objects;

public class MetricThresholdIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String thresholdDisplayName;

    public MetricThresholdIdentifier(MetricThresholdGroup group, MetricThreshold threshold) {
        this(group.getName(), threshold);
    }

    public MetricThresholdIdentifier(String groupName, MetricThreshold threshold) {
        this(groupName, threshold.getDisplayName());
    }

    public MetricThresholdIdentifier(String groupName, String thresholdDisplayName) {
        this.groupName = Objects.requireNonNull(groupName);
        this.thresholdDisplayName = Objects.requireNonNull(thresholdDisplayName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getThresholdDisplayName() {
        return this.thresholdDisplayName;
    }

    public int hashCode() {
        return this.groupName.hashCode() + 31 * this.thresholdDisplayName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricThresholdIdentifier) {
            MetricThresholdIdentifier other = (MetricThresholdIdentifier)obj;
            return this.groupName.equals(other.groupName) && this.thresholdDisplayName.equals(other.thresholdDisplayName);
        }
        return false;
    }

    public String toString() {
        return this.groupName + "." + this.thresholdDisplayName;
    }
}

