/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.teamscale.core.committree.CommitSchedulingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class RichCommitDescriptor
extends ParentedCommitDescriptor {
    private static final long serialVersionUID = 1L;
    private final List<CommitDescriptor> schedulingHints = new ArrayList<CommitDescriptor>();
    private final List<CommitDescriptor> schedulingPreAnnouncements = new ArrayList<CommitDescriptor>();
    private boolean onlyHints = false;
    private boolean scheduleExternalDataTriggers;

    public RichCommitDescriptor(CommitDescriptor commitDescriptor, List<CommitDescriptor> parentCommits, List<CommitDescriptor> schedulingHints, List<CommitDescriptor> schedulingPreAnnouncements) {
        super(commitDescriptor, parentCommits);
        this.schedulingHints.addAll(schedulingHints);
        this.schedulingPreAnnouncements.addAll(schedulingPreAnnouncements);
    }

    public UnmodifiableList<CommitDescriptor> getSchedulingHints() {
        return CollectionUtils.asUnmodifiable(this.schedulingHints);
    }

    public List<CommitDescriptor> getSchedulingPreAnnouncements() {
        return this.schedulingPreAnnouncements;
    }

    public static RichCommitDescriptor createHintsOnlyDescriptor(CommitSchedulingResult commitSchedulingResult) {
        RichCommitDescriptor descriptor = new RichCommitDescriptor(CommitDescriptor.createUnbranchedDescriptor((long)0L), Collections.emptyList(), commitSchedulingResult.schedulingHints(), commitSchedulingResult.schedulingPreAnnouncements());
        descriptor.onlyHints = true;
        return descriptor;
    }

    public static boolean isOnlyHints(CommitDescriptor descriptor) {
        return descriptor instanceof RichCommitDescriptor && ((RichCommitDescriptor)descriptor).onlyHints;
    }

    public static boolean isScheduleExternalDataTriggers(CommitDescriptor descriptor) {
        return descriptor instanceof RichCommitDescriptor && ((RichCommitDescriptor)descriptor).scheduleExternalDataTriggers;
    }

    public void setScheduleExternalDataTriggers(boolean scheduleExternalDataTriggers) {
        this.scheduleExternalDataTriggers = scheduleExternalDataTriggers;
    }
}

