/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.teamscale.accesskeys;

import com.teamscale.core.authenticate.SecurityUtils;
import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKey;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.log.AuditLogs;
import org.conqat.engine.persistence.store.StorageException;

public class AccessKeyHandler {
    private static final int ACCESS_KEY_LENGTH = 32;

    public static String createAndStoreEncryptedAccessKey(String username, EncryptedAccessKeyIndex index) throws StorageException {
        String newAccessKey = SecurityUtils.getRandomString(32);
        byte[] accessKey = SecurityUtils.asByteArray(newAccessKey.toCharArray());
        String hashedKey = new HashedStoredPasswordAuthenticator().generateNewAuthenticator(accessKey);
        AccessKey key = new AccessKey(hashedKey);
        index.addAccessKey(username, key);
        AuditLogs.accessKeyCreated(username);
        return newAccessKey;
    }
}

