/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.committree;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public interface ICommitTree
extends Serializable {
    public boolean nodeExists(CommitTreeRevision var1);

    public List<? extends ICommitTreeNode> getAllNodes();

    public Optional<String> getLatestContainedRevisionForBranch(String var1);

    public Optional<String> getLatestContainedRevisionForBranch(ICommitTreeNode var1);

    public Set<String> getAllKnownBranchNames();

    public boolean isEmpty();

    public Optional<String> resolveLatestRevisionBefore(String var1, long var2);

    public @Nullable ICommitTreeNode getNodeByRevision(CommitTreeRevision var1);

    public @Nullable ICommitTreeNode getNodeByBranchAndAdjustedTimestamp(String var1, long var2);

    public UnmodifiableSet<String> getLiveBranchNames();

    public boolean isForceExpansionPending();

    default public String getCommitTreeDump() {
        StringWriter stringWriter = new StringWriter();
        this.dumpCommitTree(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    default public void dumpCommitTree(PrintWriter writer) {
        this.getAllNodes().stream().sorted(Comparator.comparingLong(ICommitTreeNode::getOriginalTimestamp).thenComparing(node -> node.getRevision().getBranchName(), Comparator.nullsLast(Comparator.naturalOrder()))).forEach(node -> ICommitTree.dumpTreeNode(node, writer));
    }

    private static void dumpTreeNode(ICommitTreeNode node, PrintWriter writer) {
        writer.println(String.valueOf(node.getRevision()) + " (state: " + String.valueOf((Object)node.getState()) + ", timestamp: " + node.getOriginalTimestamp() + ", adjusted: " + String.valueOf(node.getAdjustedTimestamp()) + ")");
        node.getParentRevisions().forEach(parent -> writer.println("    " + String.valueOf(parent)));
    }
}

