/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.concurrency;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collector;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

class ExecutorServiceParallelTaskExecutor
implements IParallelTaskExecutor {
    private static final int UNKNOWN_PARALLELISM = 0;
    private final ExecutorService executorService;
    private final int maximumParallelism;

    public ExecutorServiceParallelTaskExecutor(ExecutorService executorService) {
        CCSMAssert.isNotNull((Object)executorService, () -> String.format("Expected \"%s\" to be not null", "executorService"));
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            this.maximumParallelism = threadPoolExecutor.getMaximumPoolSize();
        } else if (executorService instanceof ForkJoinPool) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)executorService;
            this.maximumParallelism = forkJoinPool.getParallelism();
        } else {
            this.maximumParallelism = 0;
        }
        this.executorService = executorService;
    }

    @Override
    public OptionalInt maximumParallelism() {
        if (this.maximumParallelism == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.maximumParallelism + 1);
    }

    @Override
    public <T, R> R executeInParallelAndCombine(Collection<Callable<T>> tasks, Collector<T, ?, R> collector) throws ExecutionException, InterruptedException {
        List<Future<T>> futures = this.executeTasks(tasks);
        return ExecutorServiceParallelTaskExecutor.awaitAndCollectResults(futures, collector);
    }

    private <T> List<Future<T>> executeTasks(Collection<Callable<T>> tasks) {
        List futureTasks = CollectionUtils.map(tasks, FutureTask::new);
        LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>(futureTasks);
        Runnable taskExecutor = () -> ExecutorServiceParallelTaskExecutor.executeNextTaskIfPresent(taskQueue);
        for (int i = 0; i < taskQueue.size(); ++i) {
            this.executorService.submit(taskExecutor);
        }
        ExecutorServiceParallelTaskExecutor.participateInTaskExecution(taskQueue);
        return new ArrayList<Future<T>>(futureTasks);
    }

    private static void participateInTaskExecution(Queue<Runnable> queue) {
        boolean hadTaskToExecute;
        while (hadTaskToExecute = ExecutorServiceParallelTaskExecutor.executeNextTaskIfPresent(queue)) {
        }
    }

    private static boolean executeNextTaskIfPresent(Queue<Runnable> queue) {
        Runnable runnable = queue.poll();
        if (runnable != null) {
            runnable.run();
            return true;
        }
        return false;
    }

    private static <T, A, R> R awaitAndCollectResults(Collection<Future<T>> futures, Collector<T, A, R> resultCollector) throws InterruptedException, ExecutionException {
        A intermediateResult = resultCollector.supplier().get();
        ExecutionException executionException = null;
        for (Future<T> future : futures) {
            try {
                T result = future.get();
                resultCollector.accumulator().accept(intermediateResult, result);
            }
            catch (ExecutionException e) {
                if (executionException == null) {
                    executionException = e;
                    continue;
                }
                executionException.addSuppressed(e);
            }
        }
        if (executionException != null) {
            throw executionException;
        }
        return resultCollector.finisher().apply(intermediateResult);
    }
}

