/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.service.ShortServiceLog;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ShortCriticalEventServiceLog
extends ShortServiceLog {
    private static final long serialVersionUID = 1L;
    private static final String EVENT_MESSAGE_PROPERTY_NAME = "eventMessage";
    private static final String ROLLBACK_ID_PROPERTY_NAME = "rollbackId";
    @JsonProperty(value="eventMessage")
    private final String eventMessage;
    @JsonProperty(value="rollbackId")
    private final @Nullable UUID rollbackId;

    public ShortCriticalEventServiceLog(ShortServiceLog criticalService, String eventMessage, InternalProjectId projectId, @Nullable UUID rollbackId) {
        super(criticalService.getId(), criticalService.getTarget(), criticalService.httpMethod, criticalService.username, criticalService.parameters, criticalService.getLogCount(), projectId);
        this.eventMessage = ShortCriticalEventServiceLog.formatTimestampsAsDates(eventMessage);
        this.rollbackId = rollbackId;
    }

    public String getEventMessage() {
        return this.eventMessage;
    }

    public @Nullable UUID getRollbackId() {
        return this.rollbackId;
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.eventMessage, Optional.ofNullable(this.rollbackId).map(UUID::toString).orElse("")));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append(this.eventMessage).append(" (").append(this.rollbackId).append(") ");
    }
}

