/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.permissions.PermissionLookup;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PermissionFilter<S, T> {
    private final PermissionLookup<T> permissionLookup;
    private final Function<S, String> identityExtractor;
    private final T neededPermission;

    public PermissionFilter(PermissionLookup<T> permissionLookup, Function<S, String> identityExtractor, T neededPermission) {
        this.permissionLookup = permissionLookup;
        this.identityExtractor = identityExtractor;
        this.neededPermission = neededPermission;
    }

    public List<S> filter(List<S> objects) {
        return objects.stream().filter((? super T object) -> this.permissionLookup.hasPermission(this.identityExtractor.apply(object), this.neededPermission)).collect(Collectors.toList());
    }
}

