/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class PreAnnouncements {
    private final AnalysisProgressIndexBase progressIndex;
    private final Map<String, DurableSet<CommitDescriptor>> schedulingPreAnnouncementsByTriggerName;
    private final Map<String, Map<String, SortedSet<Long>>> preAnnouncementsByBranchByTriggerName;
    private Map<String, Long> firstPreAnnouncementByBranch;

    private PreAnnouncements(AnalysisProgressIndexBase progressIndex, Map<String, DurableSet<CommitDescriptor>> schedulingPreAnnouncementsByTriggerName, Map<String, Map<String, SortedSet<Long>>> preAnnouncementsByBranchByTriggerName, Map<String, Long> firstPreAnnouncementByBranch) {
        this.progressIndex = progressIndex;
        this.schedulingPreAnnouncementsByTriggerName = schedulingPreAnnouncementsByTriggerName;
        this.preAnnouncementsByBranchByTriggerName = preAnnouncementsByBranchByTriggerName;
        this.firstPreAnnouncementByBranch = firstPreAnnouncementByBranch;
    }

    synchronized void insertPreAnnouncements(String triggerName, List<CommitDescriptor> newPreAnnouncements) throws StorageException {
        this.getPreAnnouncements(triggerName).addAll(newPreAnnouncements);
        Map preAnnouncementsByBranch = this.preAnnouncementsByBranchByTriggerName.computeIfAbsent(triggerName, ignoredTriggerName -> new HashMap());
        for (CommitDescriptor newPreAnnouncement : newPreAnnouncements) {
            preAnnouncementsByBranch.computeIfAbsent(newPreAnnouncement.getBranchName(), ignoredBranchName -> new TreeSet()).add(newPreAnnouncement.getTimestamp());
            this.firstPreAnnouncementByBranch.merge(newPreAnnouncement.getBranchName(), newPreAnnouncement.getTimestamp(), Math::min);
        }
    }

    private DurableSet<CommitDescriptor> getPreAnnouncements(String triggerName) throws StorageException {
        DurableSet<CommitDescriptor> preAnnouncements;
        if (this.schedulingPreAnnouncementsByTriggerName.containsKey(triggerName)) {
            preAnnouncements = this.schedulingPreAnnouncementsByTriggerName.get(triggerName);
        } else {
            preAnnouncements = this.progressIndex.createDurablePreAnnouncementSet(triggerName);
            this.schedulingPreAnnouncementsByTriggerName.put(triggerName, preAnnouncements);
        }
        return preAnnouncements;
    }

    synchronized void removePreAnnouncement(String triggerName, CommitDescriptor commit) {
        SortedSet<Long> preAnnouncedTimestamps;
        Map<String, SortedSet<Long>> preAnnouncedCommitsByBranch;
        DurableSet<CommitDescriptor> preAnnouncedCommits = this.schedulingPreAnnouncementsByTriggerName.get(triggerName);
        if (!CollectionUtils.isNullOrEmpty(preAnnouncedCommits)) {
            preAnnouncedCommits.remove((Object)commit);
        }
        if (!CollectionUtils.isNullOrEmpty(preAnnouncedCommitsByBranch = this.preAnnouncementsByBranchByTriggerName.get(triggerName)) && !CollectionUtils.isNullOrEmpty(preAnnouncedTimestamps = preAnnouncedCommitsByBranch.get(commit.getBranchName()))) {
            preAnnouncedTimestamps.remove(commit.getTimestamp());
        }
        this.firstPreAnnouncementByBranch.remove(commit.getBranchName());
        Long firstPreAnnouncement = this.computeFirstPreAnnouncedTimestamp(commit.getBranchName());
        if (firstPreAnnouncement != null) {
            this.firstPreAnnouncementByBranch.put(commit.getBranchName(), firstPreAnnouncement);
        }
    }

    synchronized Map<String, Long> getFirstPreAnnouncementByBranch() {
        return Map.copyOf(this.firstPreAnnouncementByBranch);
    }

    List<CommitDescriptor> getFirstPreAnnouncedCommits() {
        return this.getFirstPreAnnouncementByBranch().entrySet().stream().map(entry -> new CommitDescriptor((String)entry.getKey(), ((Long)entry.getValue()).longValue())).collect(Collectors.toList());
    }

    synchronized OptionalLong getFirstPreAnnouncedTimestamp(String branch) {
        Long firstPreAnnouncedTimestamp = this.firstPreAnnouncementByBranch.get(branch);
        if (firstPreAnnouncedTimestamp == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(firstPreAnnouncedTimestamp);
    }

    private Long computeFirstPreAnnouncedTimestamp(String branch) {
        Long currentFirstPreAnnouncedTimestamp = null;
        for (Map<String, SortedSet<Long>> preAnnouncementByBranch : this.preAnnouncementsByBranchByTriggerName.values()) {
            SortedSet<Long> preAnnouncementsForBranch = preAnnouncementByBranch.get(branch);
            if (CollectionUtils.isNullOrEmpty(preAnnouncementsForBranch)) continue;
            if (currentFirstPreAnnouncedTimestamp == null) {
                currentFirstPreAnnouncedTimestamp = preAnnouncementsForBranch.first();
                continue;
            }
            currentFirstPreAnnouncedTimestamp = Math.min(currentFirstPreAnnouncedTimestamp, preAnnouncementsForBranch.first());
        }
        return currentFirstPreAnnouncedTimestamp;
    }

    private static Map<String, Long> computeFirstPreAnnouncementByBranch(Map<String, Map<String, SortedSet<Long>>> preAnnouncementsByBranchByTriggerName) {
        HashMap<String, Long> firstTimestampByBranch = new HashMap<String, Long>();
        for (Map<String, SortedSet<Long>> preAnnouncementsByBranch : preAnnouncementsByBranchByTriggerName.values()) {
            preAnnouncementsByBranch.forEach((branch, timestamps) -> {
                if (CollectionUtils.isNullOrEmpty((Collection)timestamps)) {
                    return;
                }
                Long firstTimestamp = (Long)timestamps.first();
                Long currentFirstTimestamp = (Long)firstTimestampByBranch.get(branch);
                if (currentFirstTimestamp == null || firstTimestamp < currentFirstTimestamp) {
                    firstTimestampByBranch.put((String)branch, firstTimestamp);
                }
            });
        }
        return firstTimestampByBranch;
    }

    synchronized void rollbackTo(CommitDescriptor preserveCommit, Map<String, Long> timestampForBranch) {
        if (preserveCommit == null) {
            for (DurableSet<CommitDescriptor> durableSet : this.schedulingPreAnnouncementsByTriggerName.values()) {
                durableSet.clear();
            }
            for (Map map : this.preAnnouncementsByBranchByTriggerName.values()) {
                map.clear();
            }
            this.firstPreAnnouncementByBranch.clear();
            return;
        }
        for (String string : this.schedulingPreAnnouncementsByTriggerName.keySet()) {
            DurableSet<CommitDescriptor> preAnnouncedCommits = this.schedulingPreAnnouncementsByTriggerName.get(string);
            Map<String, SortedSet<Long>> preAnnouncementsByBranch = this.preAnnouncementsByBranchByTriggerName.get(string);
            for (CommitDescriptor commit : new ArrayList<CommitDescriptor>((Collection<CommitDescriptor>)preAnnouncedCommits)) {
                Long cutOffTimestamp = timestampForBranch.get(commit.getBranchName());
                if (cutOffTimestamp == null || cutOffTimestamp >= commit.getTimestamp()) continue;
                preAnnouncedCommits.remove((Object)commit);
                preAnnouncementsByBranch.computeIfAbsent(commit.getBranchName(), ignored -> new TreeSet()).remove(commit.getTimestamp());
            }
        }
        this.firstPreAnnouncementByBranch = PreAnnouncements.computeFirstPreAnnouncementByBranch(this.preAnnouncementsByBranchByTriggerName);
    }

    static PreAnnouncements create(AnalysisProgressIndexBase progressIndex) throws StorageException {
        Map<String, DurableSet<CommitDescriptor>> schedulingPreAnnouncementsByTriggerName = progressIndex.loadPreAnnouncements();
        HashMap<String, Map<String, SortedSet<Long>>> preAnnouncementsByBranchByTriggerName = new HashMap<String, Map<String, SortedSet<Long>>>();
        schedulingPreAnnouncementsByTriggerName.forEach((triggerName, preAnnouncedCommits) -> {
            HashMap<String, SortedSet> preAnnouncementsByBranch = new HashMap<String, SortedSet>();
            for (CommitDescriptor commit : preAnnouncedCommits) {
                preAnnouncementsByBranch.computeIfAbsent(commit.getBranchName(), ignored -> new TreeSet()).add(commit.getTimestamp());
            }
            preAnnouncementsByBranchByTriggerName.put((String)triggerName, (Map<String, SortedSet<Long>>)preAnnouncementsByBranch);
        });
        return new PreAnnouncements(progressIndex, schedulingPreAnnouncementsByTriggerName, preAnnouncementsByBranchByTriggerName, PreAnnouncements.computeFirstPreAnnouncementByBranch(preAnnouncementsByBranchByTriggerName));
    }

    boolean isPreAnnouncementCausedByJob(ScheduledJob job, String branchName, long firstPreAnnouncedTimestamp) {
        Map<String, SortedSet<Long>> announcementsForTrigger = this.preAnnouncementsByBranchByTriggerName.get(job.getTriggerName());
        if (announcementsForTrigger == null) {
            return false;
        }
        return announcementsForTrigger.containsKey(branchName) && announcementsForTrigger.get(branchName).contains(firstPreAnnouncedTimestamp);
    }
}

