/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.user.UserGroup;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class User
implements Serializable,
ISubject {
    private static final String AVATAR_HASH_PLACEHOLDER = "noHash";
    private static final long serialVersionUID = 1L;
    private static final String USERNAME_PROPERTY = "username";
    private static final String FIRST_NAME_PROPERTY = "firstName";
    private static final String LAST_NAME_PROPERTY = "lastName";
    private static final String EMAIL_ADDRESS_PROPERTY = "emailAddress";
    private static final String AUTHENTICATOR_PROPERTY = "authenticator";
    private static final String AVATAR_HASH_PROPERTY = "avatarHash";
    protected static final String GROUP_IDS_PROPERTY = "groupIds";
    @JsonProperty(value="username")
    private final @NonNull String username;
    @JsonProperty(value="firstName")
    private final String firstName;
    @JsonProperty(value="lastName")
    private final String lastName;
    @JsonProperty(value="emailAddress")
    private final String emailAddress;
    @JsonProperty(value="aliases")
    private final SequencedSet<String> aliases = new LinkedHashSet<String>();
    @JsonProperty(value="authenticator")
    private @Nullable String authenticator;
    @JsonProperty(value="groupIds")
    private Set<String> groupIds = new HashSet<String>();
    @JsonIgnore
    private HashMap<String, String> additionalDetails = new HashMap();
    @JsonProperty(value="avatarHash")
    private String avatarHash = "noHash";

    @JsonCreator
    public User(@JsonProperty(value="username") String username, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="authenticator") @Nullable String authenticator) {
        CCSMAssert.isNotNull((Object)username, (String)"Username must not be null");
        this.username = username.toLowerCase();
        this.firstName = firstName;
        this.lastName = lastName;
        this.emailAddress = emailAddress;
        this.authenticator = authenticator;
    }

    @VisibleForTesting
    public User(String username, String firstName, String lastName, String emailAddress, @Nullable String authenticator, Collection<String> aliases) {
        this(username, firstName, lastName, emailAddress, authenticator);
        this.setAliases(aliases);
    }

    public User(User user) {
        this(user.username, user.firstName, user.lastName, user.emailAddress, user.authenticator, user.aliases);
        this.groupIds = new HashSet<String>(user.groupIds);
        this.additionalDetails = user.additionalDetails;
        this.avatarHash = user.avatarHash;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public @Nullable String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nullable String authenticator) {
        this.authenticator = authenticator;
    }

    public @NonNull String getUsername() {
        return this.username;
    }

    public String getAvatarHash() {
        return this.avatarHash;
    }

    public String getFullName() {
        if (StringUtils.isEmpty((String)this.firstName) && StringUtils.isEmpty((String)this.lastName)) {
            return this.username;
        }
        if (StringUtils.isEmpty((String)this.firstName)) {
            return this.getLastName();
        }
        if (StringUtils.isEmpty((String)this.lastName)) {
            return this.getFirstName();
        }
        return this.getFirstName() + " " + this.getLastName();
    }

    public UnmodifiableSet<String> getAliases() {
        return CollectionUtils.asUnmodifiable(this.aliases);
    }

    public void addAliases(String ... aliases) {
        this.addAliases(Arrays.asList(aliases));
    }

    public void addAliases(Collection<String> aliases) {
        this.aliases.addAll(aliases);
        this.aliases.remove(this.username);
    }

    public void setAliases(Collection<String> aliases) {
        this.aliases.clear();
        this.addAliases(aliases);
    }

    public void addGroup(UserGroup group) {
        this.groupIds.add(group.getName());
    }

    public void removeGroup(UserGroup group) {
        this.removeGroupByName(group.getName());
    }

    public void removeGroupByName(String groupName) {
        this.groupIds.remove(groupName);
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(Set<String> groupIds) {
        this.groupIds = groupIds;
    }

    public void setAvatarHash(String avatarHash) {
        this.avatarHash = avatarHash;
    }

    public boolean addGroupIds(Set<String> groupIds) {
        return this.groupIds.addAll(groupIds);
    }

    public String toString() {
        return this.username + " (" + this.firstName + " " + this.lastName + ")";
    }

    public String toWebUIString() {
        return this.firstName + " " + this.lastName + " [" + this.username + "]";
    }

    public String getAdditionalField(String fieldName) {
        return this.getAdditionalDetailsMap().get(fieldName);
    }

    public void setAdditionalField(String key, String value) {
        this.getAdditionalDetailsMap().put(key, value);
    }

    public HashMap<String, String> getAdditionalDetailsMap() {
        if (this.additionalDetails == null) {
            this.additionalDetails = new HashMap();
        }
        return this.additionalDetails;
    }

    public void setAdditionalDetailsMap(HashMap<String, String> additionalDetailsMap) {
        this.additionalDetails = additionalDetailsMap;
    }

    @Override
    public String getSubjectId() {
        return this.getUsername();
    }

    @Override
    public ESubjectType getSubjectType() {
        return ESubjectType.USER;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.username, user.username) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.emailAddress, user.emailAddress) && Objects.equals(this.aliases, user.aliases) && Objects.equals(this.authenticator, user.authenticator) && Objects.equals(this.groupIds, user.groupIds) && Objects.equals(this.additionalDetails, user.additionalDetails) && Objects.equals(this.avatarHash, user.avatarHash);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.firstName, this.lastName, this.emailAddress, this.aliases, this.authenticator, this.groupIds, this.additionalDetails, this.avatarHash);
    }
}

