/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.SetMap;

public class ArchitectureAnnotator {
    private final ArchitectureDefinition architecture;
    private final List<Dependency> dependencies;
    private final TypeComponentMapping mapping;
    private final SetMap<String, String> scope = new SetMap();

    public ArchitectureAnnotator(ArchitectureDefinition architecture, TypeComponentMapping mapping, List<Dependency> dependencyList, SetMap<String, String> scope) {
        this.architecture = architecture;
        this.mapping = mapping;
        this.dependencies = dependencyList;
        this.scope.addAll(scope);
    }

    public ArchitectureAnnotator(ArchitectureDefinition architecture, TypeComponentMapping mapping, List<Dependency> dependencyList) {
        this.architecture = architecture;
        this.mapping = mapping;
        this.dependencies = dependencyList;
        for (Dependency dependency : dependencyList) {
            for (TypeDependency abc : dependency.getTypeDependencies()) {
                this.scope.add((Object)abc.getSource(), (Object)abc.getTarget());
            }
        }
    }

    public void assess() {
        for (Constraint constraint : this.architecture.getConstraints()) {
            constraint.assess(this.scope);
        }
    }

    public void annotateArchitectureWithResult() throws ConQATException {
        for (ComponentNode component : this.architecture.getAllComponents()) {
            component.setMatchedTypes(this.mapping.getMappedTypes(component));
        }
        this.architecture.setOrphans(this.mapping.getUnmatchedTypes());
        this.architecture.setRedundantIncludePatterns(this.mapping.getRedundantIncludePatterns());
        this.architecture.setComponentOverlaps(this.mapping.getComponentOverlaps());
        this.architecture.setNumberOfMatches(this.mapping.getNumberOfMatches());
        ArchitectureAnnotator.insertDependenciesToArchitecture(this.dependencies);
    }

    private static void insertDependenciesToArchitecture(List<Dependency> dependencies) throws ConQATException {
        for (Dependency dependency : dependencies) {
            ArchitectureAnnotator.insert(dependency);
        }
    }

    private static void insert(Dependency dependency) throws ConQATException {
        ComponentNode target;
        ComponentNode source = dependency.getSource();
        DependencyPolicy policy = source.getPolicyTo(target = dependency.getTarget());
        if (policy == null) {
            policy = new DependencyPolicy(source, target, dependency.getType(), null);
            policy.registerWithComponents();
        }
        for (TypeDependency typeDependency : dependency.getTypeDependencies()) {
            policy.addTypeDependency(typeDependency);
        }
    }
}

