/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.teamscale.index.check.CheckPhaseResultIndexBase;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.TestOnly;

@Index(name="check-phase-results", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={IExtractedValue.class})
public class CheckPhaseResultIndex
extends CheckPhaseResultIndexBase
implements IProjectIndex {
    public static final String NAME = "check-phase-results";

    public CheckPhaseResultIndex(IStore store) {
        super(store);
    }

    @Override
    protected boolean abbreviateKeyPart() {
        return true;
    }

    public void remove(List<String> uniformPaths, List<Class<? extends IGlobalExtractionPhase<?, ?>>> phases) throws StorageException {
        HashSet<String> names = new HashSet<String>(uniformPaths);
        phases.forEach(phase -> names.add(phase.getName()));
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(names);
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (Class<IGlobalExtractionPhase<?, ?>> phase2 : phases) {
            int phaseId = (Integer)abbreviationMap.get(phase2.getName());
            for (String uniformPath : uniformPaths) {
                keys.add(this.makeKeyForUniformPath(phaseId, uniformPath, abbreviationMap));
            }
        }
        this.store.remove(keys);
    }

    public void storeValues(Map<Class<? extends IGlobalExtractionPhase<?, ?>>, PairList<String, List<? extends IExtractedValue<?>>>> extractedValues) throws StorageException {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<Class<IGlobalExtractionPhase<?, ?>>, PairList<String, List<IExtractedValue<?>>>> entry : extractedValues.entrySet()) {
            names.add(entry.getKey().getName());
            names.addAll(entry.getValue().extractFirstList());
        }
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(names);
        PairList keysValues = new PairList();
        for (Map.Entry<Class<IGlobalExtractionPhase<?, ?>>, PairList<String, List<IExtractedValue<?>>>> entry : extractedValues.entrySet()) {
            String phaseName = entry.getKey().getName();
            int abbreviatedPhaseName = (Integer)abbreviationMap.get(phaseName);
            for (Pair entry2 : entry.getValue()) {
                String uniformPath = (String)entry2.getFirst();
                List values = (List)entry2.getSecond();
                byte[] serializedValue = this.serializeCheckPhaseResultValues(values, phaseName, uniformPath);
                keysValues.add((Object)this.makeKeyForUniformPath(abbreviatedPhaseName, uniformPath, abbreviationMap), (Object)serializedValue);
            }
        }
        this.store.put(keysValues);
    }

    private byte[] serializeCheckPhaseResultValues(List<? extends IExtractedValue<?>> values, String phaseName, String uniformPath) throws StorageException {
        try {
            return this.serializeValueList(values, IExtractedValue::getValue, IExtractedValue::getAdditionalInformation);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError newError = new OutOfMemoryError("OOM while serializing check-phase result from " + phaseName + " on " + uniformPath);
            newError.addSuppressed(e);
            throw newError;
        }
        catch (StorageException e) {
            throw new StorageException("Exception while serializing check-phase result from " + phaseName + " on " + uniformPath, (Throwable)e);
        }
    }

    public List<CheckPhaseResultIndexBase.RawExtractedValue<?>> getRawValues(String phase, List<String> paths, Class<? extends IGlobalExtractionPhase<?, ?>> contextClass) throws StorageException {
        HashSet<String> names = new HashSet<String>(paths);
        names.add(phase);
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(names);
        int phaseId = (Integer)abbreviationMap.get(phase);
        List values = this.store.get(CollectionUtils.map(paths, path -> this.makeKeyForUniformPath(phaseId, (String)path, abbreviationMap)));
        ArrayList result = new ArrayList();
        for (int i = 0; i < paths.size(); ++i) {
            String path2 = paths.get(i);
            if (values.get(i) == null) continue;
            result.addAll(this.deserializeValueList((byte[])values.get(i), path2, contextClass));
        }
        return result;
    }

    @TestOnly
    public List<byte[]> getAllKeysForTesting() throws StorageException {
        return StorageUtils.listKeys((IStore)this.store);
    }

    @Override
    protected <D extends Serializable> CheckPhaseResultIndexBase.RawExtractedValue<D> createRawExtractedValue(String pathOrValue, String firstString, D additionalInformation) {
        return new CheckPhaseResultIndexBase.RawExtractedValue<D>(pathOrValue, firstString, additionalInformation);
    }

    public <D extends Serializable> List<IExtractedValue<D>> getValuesCached(Class<? extends IGlobalExtractionPhase<?, ?>> phaseClass, String uniformPath) throws StorageException {
        return this.getValuesCachedInternal(phaseClass, uniformPath);
    }
}

