/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.constraint;

import com.teamscale.index.code_clones.constraint.ICloneClassConstraint;
import com.teamscale.index.code_clones.constraint.UnitListDelta;
import com.teamscale.index.code_clones.constraint.UnitListDiffer;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.core.Unit;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SimilarityConstraint
implements ICloneClassConstraint {
    private static final double SIMILARITY_THRESHOLD = 0.5;
    private static final double EQUALITY_THRESHOLD = 0.3;
    private static final double TERM_EQUALITY_THRESHOLD = 0.3;
    private static final Set<ELanguage> SKIPPED_LANGUAGES = EnumSet.of(ELanguage.COBOL, ELanguage.LINE, ELanguage.XML);

    @Override
    public boolean satisfied(CloneClass cloneClass) {
        if (SKIPPED_LANGUAGES.contains(ELanguage.fromPath((String)Objects.requireNonNull((Clone)CollectionUtils.getAny(cloneClass.getClones())).getUniformPath()))) {
            return true;
        }
        ArrayList<List<Unit>> tokenUnitLists = new ArrayList<List<Unit>>();
        for (Clone clone : cloneClass.getClones()) {
            tokenUnitLists.add(SimilarityConstraint.getUnits(clone));
        }
        UnitListDelta delta = UnitListDiffer.computeDelta(tokenUnitLists);
        return delta.getSimilarity() >= 0.5 && delta.getEquality() >= 0.3 && delta.getTermEquality() >= 0.3;
    }

    private static List<Unit> getUnits(Clone clone) {
        List<Unit> units = clone.getUnits();
        if (units == null) {
            throw new AssertionError((Object)"This constraint can only be used if the units are stored.");
        }
        return units;
    }
}

