/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.SwiftPlatformConditions;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.string.StringUtils;

public class SwiftLanguageAdjustmentConfiguration
extends AnalysisConfigurationBase {
    public static final String CONDITIONAL_COMPILATION_PROCESSING_OPTION_NAME = "Swift: Enable Conditional Compilation Block Interpretation";
    public static final String PLATFORM_CONDITIONS_DEFINITION_OPTION_NAME = "Swift: Platform Conditions Definitions";
    public static final String CUSTOM_COMPILATION_FLAGS_OPTION_NAME = "Swift: Enabled Custom Compilation Flags";
    private static final String DESCRIPTION_ENABLE_PROCESSING_OPTION = "Enable the interpretation of conditional compilation blocks (#if-blocks).";
    private static final String DESCRIPTION_PLATFORM_CONDITIONS_OPTION = "Newline-separated list of platform condition definitions.\n<p></p>\n**Example**:<br>\n`os := macOS`<br>\n`swift := 5.9`<br>\n`canImport := MyModule, 5.8`<br>\nSpecifies to assume `macOS` as value for `os`, version `5.9` as value for `swift`, and module `MyModule` in version `5.8` can be imported.\n<p></p>\nPlatform conditions influence the interpretation of conditional compilation blocks,\nsince they are used in said blocks to check if the target platform satisfies a set of conditions.\nIf a platform condition is *not defined* here, this check *always* yields `false`, i.e., the condition is not satisfied.";
    private static final String DESCRIPTION_CUSTOM_FLAGS_OPTION = "Comma- or newline-separated list of enabled custom compilation flags, e.g,\n`VERBOSE, DEBUG` to enable the flags `VERBOSE` and `DEBUG`.\n<p></p>\nCustom compilation flags are user-provided boolean flags that influence the interpretation of conditional compilation blocks,\nsince they can be referenced in the conditions of said blocks.\nA custom compilation flag is *enabled* (has value `true`) if and only if it is *explicitly specified* as enabled;\notherwise, it is *disabled* (has value `false`).";
    @ConfigExposed(name="Swift: Enable Conditional Compilation Block Interpretation", description="Enable the interpretation of conditional compilation blocks (#if-blocks).", dependentOptions={"Swift: Platform Conditions Definitions", "Swift: Platform Conditions Definitions"})
    private CodeScopeAware<Boolean> enableConditionalCompilationProcessing = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Swift: Platform Conditions Definitions", description="Newline-separated list of platform condition definitions.\n<p></p>\n**Example**:<br>\n`os := macOS`<br>\n`swift := 5.9`<br>\n`canImport := MyModule, 5.8`<br>\nSpecifies to assume `macOS` as value for `os`, version `5.9` as value for `swift`, and module `MyModule` in version `5.8` can be imported.\n<p></p>\nPlatform conditions influence the interpretation of conditional compilation blocks,\nsince they are used in said blocks to check if the target platform satisfies a set of conditions.\nIf a platform condition is *not defined* here, this check *always* yields `false`, i.e., the condition is not satisfied.", multilineText=true, validator=SwiftPlatformConfigValidator.class)
    private CodeScopeAware<String> definedPlatformConditions = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Swift: Enabled Custom Compilation Flags", description="Comma- or newline-separated list of enabled custom compilation flags, e.g,\n`VERBOSE, DEBUG` to enable the flags `VERBOSE` and `DEBUG`.\n<p></p>\nCustom compilation flags are user-provided boolean flags that influence the interpretation of conditional compilation blocks,\nsince they can be referenced in the conditions of said blocks.\nA custom compilation flag is *enabled* (has value `true`) if and only if it is *explicitly specified* as enabled;\notherwise, it is *disabled* (has value `false`).", multilineText=true, validator=SwiftCustomFlagsValidator.class)
    private CodeScopeAware<Set<String>> enabledCustomCompilationFlags = CodeScopeAware.defaultCodeScopeWithValue(Collections.emptySet());

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (languages.contains(ELanguage.SWIFT)) {
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("enableConditionalCompilationProcessing", template.getCodeScope()));
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("definedPlatformConditions", template.getCodeScope()));
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("enabledCustomCompilationFlags", template.getCodeScope()));
        }
    }

    public static class SwiftPlatformConfigValidator
    implements ConfigExposed.IOptionValueValidator {
        public void validate(String value) throws ProjectConfigurationException {
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            try {
                SwiftPlatformConditions.parseConfig((String)value);
            }
            catch (Exception e) {
                throw new ProjectConfigurationException("Swift: Invalid configuration for 'Swift: Platform Conditions Definitions' - " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class SwiftCustomFlagsValidator
    implements ConfigExposed.IOptionValueValidator {
        private static final Predicate<String> CONTAINS_NON_WORD_CHARS = Pattern.compile("\\W", 256).asPredicate();

        public void validate(String value) throws ProjectConfigurationException {
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            String invalidValues = StringUtils.splitToList((String)value, (String)"[,\n]").stream().filter(CONTAINS_NON_WORD_CHARS).collect(Collectors.joining(", "));
            if (!StringUtils.isEmpty((String)invalidValues)) {
                throw new ProjectConfigurationException("Swift: Invalid values in 'Swift: Enabled Custom Compilation Flags' - Non-word characters in: " + invalidValues);
            }
        }
    }
}

