/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.java;

import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class JvmTypeVisitor
implements IShallowEntityVisitor {
    private static final Set<String> TYPE_SUBTYPES = Stream.of("class", "enum", "interface", "@interface").collect(Collectors.toSet());
    private static final TokenPattern EXTENDS_CLASS = LanguageFeatureParser.JAVA.classExtendsPattern().sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0);
    private String packageName;
    private final Stack<String> currentScope = new Stack();
    private final List<Type> types = new ArrayList<Type>();

    public boolean visit(ShallowEntity entity) {
        String subtype = entity.getSubtype();
        switch (entity.getType()) {
            case META: {
                if (!subtype.equalsIgnoreCase(ETokenType.PACKAGE.name())) break;
                this.packageName = entity.getName();
                break;
            }
            case TYPE: {
                if (!TYPE_SUBTYPES.contains(entity.getSubtype().toLowerCase())) break;
                this.visitType(entity);
                this.currentScope.push(entity.getName());
                break;
            }
        }
        return true;
    }

    private void visitType(ShallowEntity typeEntity) {
        Type type = new Type(this.toQualifiedName(typeEntity.getName()), JvmTypeVisitor.getSuperTypes(typeEntity));
        this.types.add(type);
    }

    private static List<String> getSuperTypes(ShallowEntity type) {
        return Optional.ofNullable(EXTENDS_CLASS.findFirstMatch((List)type.ownStartTokens())).stream().map(match -> match.groupString(0)).toList();
    }

    private String getCurrentNamespace() {
        Object namespace = "";
        if (!StringUtils.isEmpty((String)this.packageName)) {
            namespace = this.packageName + ".";
        }
        if (!this.currentScope.empty()) {
            namespace = (String)namespace + StringUtils.concat(this.currentScope, (String)"$") + "$";
        }
        return namespace;
    }

    protected String toQualifiedName(String entityName) {
        return this.getCurrentNamespace() + entityName;
    }

    public void endVisit(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.TYPE && TYPE_SUBTYPES.contains(entity.getSubtype().toLowerCase())) {
            this.currentScope.pop();
        }
    }

    public List<Type> getTypes() {
        return CollectionUtils.asUnmodifiable(this.types);
    }
}

