/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.external.ExternalStorageBackendResolvedCommitAndRevision;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RevisionResolver;
import com.teamscale.index.testimpact.CommitAndRevision;
import com.teamscale.index.utils.ExternalUploadUtils;
import jakarta.ws.rs.BadRequestException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class ExternalAnalysisSessionCreationUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ExternalAnalysisSessionInfo createSession(SessionParameters parameters, InternalProjectId projectId, IndexLayer indexLayer, String userName, PredicateWithException<CommitDescriptor, StorageException> shouldRejectUpload, SupplierWithException<IStore, StorageException> openExternalResultRawStore) throws BadRequestException, StorageException, UploadRejectedException {
        ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)indexLayer.openProjectIndex((IProjectId)projectId, ExternalAnalysisImportSessionIndex.class, null);
        LOGGER.traceEntry("createSession(parameters={}, sessionIndex={})", new Object[]{parameters, sessionIndex});
        CommitDescriptor resolvedSessionCommit = ExternalAnalysisSessionCreationUtils.resolveSessionCommit(parameters.targetStorage().orElse(null), parameters, shouldRejectUpload, userName, projectId, indexLayer, openExternalResultRawStore);
        String repository = ExternalAnalysisSessionCreationUtils.resolveRepository(parameters.commitAndRevision(), userName, projectId, indexLayer);
        LOGGER.trace("Creating session info ...");
        ExternalAnalysisSessionInfo session = sessionIndex.createSessionInfoForCommit(new ExternalStorageBackendResolvedCommitAndRevision(resolvedSessionCommit, parameters.commitAndRevision().revision(), repository), parameters.targetStorage().orElse(null), userName, parameters.uploadMessage(), parameters.partition().trim(), parameters.moveToLastCommit(), parameters.repositoryId());
        return (ExternalAnalysisSessionInfo)LOGGER.traceExit((Object)session);
    }

    private static CommitDescriptor resolveSessionCommit(@Nullable ExternalStorageBackend targetStorage, SessionParameters parameters, PredicateWithException<CommitDescriptor, StorageException> shouldRejectUpload, String userName, InternalProjectId projectId, IndexLayer indexLayer, SupplierWithException<IStore, StorageException> openExternalResultRawStore) throws StorageException, UploadRejectedException {
        LOGGER.trace("Resolving session commit from {}", (Object)parameters.commitAndRevision().toString());
        CommitDescriptor resolvedSessionCommit = ExternalAnalysisSessionCreationUtils.getUploadCommit(parameters, shouldRejectUpload, indexLayer, projectId, userName);
        if (targetStorage != null) {
            LOGGER.trace("Skipping timestamp adjustment for external storage backend for {}", (Object)parameters.commitAndRevision().toString());
            return resolvedSessionCommit;
        }
        LOGGER.trace("Resolving corrected commit from {}", (Object)resolvedSessionCommit.toString());
        return ExternalAnalysisSessionCreationUtils.getCorrectedCommit(resolvedSessionCommit, openExternalResultRawStore);
    }

    private static CommitDescriptor getUploadCommit(SessionParameters parameters, PredicateWithException<CommitDescriptor, StorageException> shouldRejectUploadIfTooOld, IndexLayer indexLayer, InternalProjectId projectId, String userName) throws BadRequestException, StorageException, UploadRejectedException {
        CommitDescriptor resolvedCommit = RevisionResolver.resolveRevisionOrCommit(parameters.commitAndRevision(), userName, projectId, indexLayer);
        ExternalAnalysisSessionCreationUtils.checkBranchExists(resolvedCommit.getBranchName(), indexLayer, projectId);
        if (shouldRejectUploadIfTooOld.test((Object)resolvedCommit)) {
            throw new UploadRejectedException(resolvedCommit);
        }
        return resolvedCommit;
    }

    private static void checkBranchExists(String branchName, IndexLayer indexLayer, InternalProjectId projectId) throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = (ProjectRepositoryChangeIndex)indexLayer.openProjectIndex((IProjectId)projectId, ProjectRepositoryChangeIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        if (!branchName.equals(repositoryStatus.getDefaultBranchName()) && !repositoryStatus.getBranchNames().contains(branchName)) {
            LOGGER.warn("Branch " + branchName + " does not exist in Teamscale.");
        }
    }

    private static CommitDescriptor getCorrectedCommit(CommitDescriptor proposedCommit, SupplierWithException<IStore, StorageException> openExternalResultRawStore) throws StorageException {
        return ExternalUploadUtils.getAdjustedCommit(proposedCommit, ExternalAnalysisSessionCreationUtils.openExternalResultBranchingLayer(openExternalResultRawStore), true);
    }

    private static @Nullable String resolveRepository(CommitAndRevision commitAndRevision, String userName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        String repository = commitAndRevision.repository();
        if (commitAndRevision.revision() == null || repository != null) {
            return repository;
        }
        Optional<Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>> revisionAndRepository = RevisionResolver.resolveRevisionAndRepository(commitAndRevision.revision(), null, userName, projectId, indexLayer);
        return revisionAndRepository.map(commitDescriptorRevisionAndRepositoryPair -> ((RepositoryRevisionIndex.RevisionAndRepository)commitDescriptorRevisionAndRepositoryPair.getSecond()).repositoryIdentifier()).orElse(null);
    }

    private static CommitLayeringBranchingLayer openExternalResultBranchingLayer(SupplierWithException<IStore, StorageException> openExternalResultRawStore) throws StorageException {
        return new CommitLayeringBranchingLayer((IStore)openExternalResultRawStore.get(), (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
    }

    private ExternalAnalysisSessionCreationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    @NullMarked
    public record SessionParameters(Optional<ExternalStorageBackend> targetStorage, String partition, CommitAndRevision commitAndRevision, String uploadMessage, boolean moveToLastCommit, String repositoryId) {
    }
}

