/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.info;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.teamscale.commons.utils.StringPool;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.external.input.info.IContentAdjustable;
import com.teamscale.index.external.input.info.ILineAdjustable;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
@IndexValueClass(containedInBackup=true)
public abstract class ExternalAnalysisImportInfo<ImportType>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="partition")
    private @Nullable String partition = null;
    @JsonProperty(value="repositoryId")
    private @Nullable String repositoryId = null;
    @JsonProperty(value="reportUniformPaths")
    private Set<String> reportUniformPaths;

    protected ExternalAnalysisImportInfo(String uniformPath) {
        Preconditions.checkNotNull((Object)uniformPath);
        this.uniformPath = StringPool.intern((String)uniformPath);
        this.reportUniformPaths = new HashSet<String>();
    }

    public abstract ImportType getData();

    public String getUniformPath() {
        return this.uniformPath;
    }

    public abstract ExternalAnalysisResult<?> createAnalysisResult();

    public static boolean hasRequiredDataForAdjustment(BasicTokenElementInfo content, TokenElementLineInfo lineInfo, ExternalAnalysisImportInfo<?> importInfo) {
        return !(content == null && importInfo instanceof IContentAdjustable || lineInfo == null && importInfo instanceof ILineAdjustable);
    }

    public final ExternalAnalysisResult<?> createAdjustedAnalysisResult(@Nullable BasicTokenElementInfo content, @Nullable TokenElementLineInfo lineInfo, String uniformPath, CodeScopeName codeScopeName, IFindingAdjuster.IFactory findingsAdjusterFactory, IDependencyAdjuster.Factory dependencyAdjusterFactory) throws ConQATException {
        ExternalAnalysisImportInfo externalAnalysisImportInfo = this;
        if (externalAnalysisImportInfo instanceof IContentAdjustable) {
            IContentAdjustable contentAdjustable = (IContentAdjustable)((Object)externalAnalysisImportInfo);
            Preconditions.checkNotNull((Object)content, (String)"Content was expected to be non-null for %s", (Object)uniformPath);
            return contentAdjustable.createAdjustedAnalysisResult(content, uniformPath, codeScopeName, findingsAdjusterFactory, dependencyAdjusterFactory);
        }
        externalAnalysisImportInfo = this;
        if (externalAnalysisImportInfo instanceof ILineAdjustable) {
            ILineAdjustable lineAdjustable = (ILineAdjustable)((Object)externalAnalysisImportInfo);
            Preconditions.checkNotNull((Object)lineInfo, (String)"Line info was expected to be non-null for %s", (Object)uniformPath);
            return lineAdjustable.createAdjustedAnalysisResult(lineInfo, uniformPath);
        }
        return this.createAnalysisResult();
    }

    public void setPartition(String partition) {
        Preconditions.checkArgument((partition != null ? 1 : 0) != 0, (Object)"Can't set partition to null.");
        Preconditions.checkState((this.partition == null ? 1 : 0) != 0, (Object)"Can't set partition twice.");
        this.partition = partition;
    }

    public String getPartition() {
        Preconditions.checkState((this.partition != null ? 1 : 0) != 0, (Object)"May only get report partition if it was previously set.");
        return this.partition;
    }

    public Set<String> getReportUniformPaths() {
        return this.reportUniformPaths;
    }

    public void addUniformPath(String reportUniformPath) {
        Preconditions.checkState((!this.reportUniformPaths.contains(reportUniformPath) ? 1 : 0) != 0, (Object)"Can't set report uniform path twice.");
        this.reportUniformPaths.add(reportUniformPath);
    }

    public void addUniformPaths(Set<String> reportUniformPaths) {
        reportUniformPaths.forEach(this::addUniformPath);
    }

    public void setRepositoryId(@Nullable String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public @Nullable String getRepositoryId() {
        return this.repositoryId;
    }

    public @Nullable ExternalAnalysisImportInfo<?> merge(ExternalAnalysisImportInfo<?> infoToMerge) {
        return null;
    }

    public long getEstimatedSizeBytes() {
        long size = 32L;
        if (this.partition != null) {
            size += (long)this.partition.length();
        }
        if (this.repositoryId != null) {
            size += (long)this.repositoryId.length();
        }
        for (String reportUniformPath : this.reportUniformPaths) {
            size += (long)reportUniformPath.length();
        }
        long hashSetSize = 16L;
        long hashSetCapacity = (long)Math.ceil((double)this.reportUniformPaths.size() / 0.75);
        return size += (hashSetSize += hashSetCapacity * 4L);
    }

    public static interface IFindingAdjuster {
        public List<IndexFinding> adjust(List<DetachedFinding> var1) throws ConQATException;

        public static interface IFactory {
            public IFindingAdjuster produce(String var1, CodeScopeName var2, LocationAdjuster var3);
        }
    }

    public static interface IDependencyAdjuster {
        public ExternalDependencyInfo adjust(ExternalDependencyInfo var1) throws ConQATException;

        public static interface Factory {
            public IDependencyAdjuster produce(String var1);
        }
    }
}

