/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStatusComparator;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class ExternalAnalysisStatusInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NO_UPLOAD_TIMESTAMP = 0L;
    private static final String COMMIT_PROPERTY = "commit";
    private static final String IS_UPLOAD_PROPERTY = "isUpload";
    private static final String UPLOAD_TIMESTAMP_PROPERTY = "uploadTimestamp";
    private static final String IS_STORED_EXTERNALLY_PROPERTY = "storedExternally";
    @JsonProperty(value="commit")
    private CommitDescriptor commit;
    @JsonProperty(value="isUpload")
    private final boolean isUpload;
    @JsonProperty(value="uploadTimestamp")
    private final long uploadTimestamp;
    @JsonProperty(value="message")
    private String message = "No message";
    @JsonProperty(value="partitions")
    private final Set<String> partitions = new HashSet<String>();
    @JsonProperty(value="types")
    private final Set<EExternalAnalysisResultType> types = EnumSet.noneOf(EExternalAnalysisResultType.class);
    @JsonProperty(value="processingSteps")
    private final List<ExternalAnalysisProcessingStepInfo> processingSteps = new ArrayList<ExternalAnalysisProcessingStepInfo>();
    @JsonProperty(value="reportArchiveInfos")
    private final List<ExternalAnalysisReportArchiveInfo> reportArchiveInfos = new ArrayList<ExternalAnalysisReportArchiveInfo>();
    @JsonProperty(value="storedExternally")
    private final boolean storedExternally;

    @JsonCreator
    public ExternalAnalysisStatusInfo(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="isUpload") boolean isUpload, @JsonProperty(value="uploadTimestamp") long uploadTimestamp, @JsonProperty(value="storedExternally") boolean storedExternally) {
        this.commit = commit;
        this.isUpload = isUpload;
        this.uploadTimestamp = uploadTimestamp;
        this.storedExternally = storedExternally;
    }

    public void addProcessingStep(ExternalAnalysisProcessingStepInfo step) {
        this.processingSteps.add(step);
    }

    public void addPartition(String partition) {
        Preconditions.checkNotNull((Object)partition);
        this.partitions.add(partition);
    }

    public void addPartitions(Collection<@NonNull String> partitionsToAdd) {
        this.partitions.addAll(partitionsToAdd);
    }

    public void addType(EExternalAnalysisResultType type) {
        this.types.add(type);
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public void setCommit(CommitDescriptor commit) {
        this.commit = commit;
    }

    public boolean isStoredExternally() {
        return this.storedExternally;
    }

    public boolean isUpload() {
        return this.isUpload;
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }

    public Set<EExternalAnalysisResultType> getTypes() {
        return this.types;
    }

    public void replaceMostRecentStep(ExternalAnalysisProcessingStepInfo updatedStep) {
        this.processingSteps.set(this.processingSteps.size() - 1, updatedStep);
    }

    public UnmodifiableList<ExternalAnalysisProcessingStepInfo> getProcessingSteps() {
        return UnmodifiableList.of((List)CollectionUtils.sort(this.processingSteps, (o1, o2) -> ExternalAnalysisProcessingStatusComparator.getInstance().compare(o1.getStatus(), o2.getStatus())));
    }

    public void filterProcessingSteps(Predicate<ExternalAnalysisProcessingStepInfo> filter) {
        this.processingSteps.removeIf(filter);
    }

    public void addReportArchiveInfos(List<ExternalAnalysisReportArchiveInfo> reportArchiveInfos) {
        this.reportArchiveInfos.addAll(reportArchiveInfos);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAnalysisStatusInfo that = (ExternalAnalysisStatusInfo)o;
        return this.isUpload == that.isUpload && this.uploadTimestamp == that.uploadTimestamp && this.storedExternally == that.storedExternally && Objects.equals(this.commit, that.commit) && Objects.equals(this.message, that.message) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.types, that.types) && Objects.equals(this.processingSteps, that.processingSteps) && Objects.equals(this.reportArchiveInfos, that.reportArchiveInfos);
    }

    public int hashCode() {
        return Objects.hash(this.commit, this.isUpload, this.uploadTimestamp, this.message, this.partitions, this.types, this.processingSteps, this.reportArchiveInfos, this.storedExternally);
    }

    @VisibleForTesting
    public List<ExternalAnalysisReportArchiveInfo> getReportArchiveInfos() {
        return this.reportArchiveInfos;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public static ExternalAnalysisStatusInfo copy(@Nullable ExternalAnalysisStatusInfo source, Supplier<ExternalAnalysisStatusInfo> creatorIfNull) {
        if (source == null) {
            return creatorIfNull.get();
        }
        ExternalAnalysisStatusInfo copy = new ExternalAnalysisStatusInfo(source.commit, source.isUpload, source.uploadTimestamp, source.storedExternally);
        copy.message = source.message;
        copy.reportArchiveInfos.addAll(new ArrayList<ExternalAnalysisReportArchiveInfo>(source.reportArchiveInfos));
        copy.partitions.addAll(new ArrayList<String>(source.partitions));
        copy.types.addAll(new ArrayList<EExternalAnalysisResultType>(source.types));
        copy.processingSteps.addAll(new ArrayList<ExternalAnalysisProcessingStepInfo>(source.processingSteps));
        return copy;
    }
}

