/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.fileloaders;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.read.BackupImportOptions;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupReader;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.fileloaders.FileLoader;
import com.teamscale.index.fileloaders.IFileLoader;
import java.io.File;
import java.io.IOException;
import java.util.stream.Collectors;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;

@FileLoader(extension="zip")
public class TeamscaleBackupFileLoader
implements IFileLoader {
    public static final String EXTENSION = "zip";
    private static boolean skipValidation = false;

    @Override
    public String loadFile(File file, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration) throws IOException {
        try (ZipFile backupFile = new ZipFile(file);){
            BackupImportOptions backupImportOptions = new BackupImportOptions().setImportGlobalData(true).setSkipValidation(skipValidation);
            BackupReadingParameters parameters = new BackupReadingParameters(backupImportOptions, indexLayer, FileSystemUtils.getTmpDir(), lockProvider, instanceConfiguration);
            BackupImportStatus status = BackupReader.importBackupData(backupFile, parameters, ICancelable.neverCanceled(), IParallelTaskExecutor.sameThread());
            if (status.getStatus() == EBackupStatus.FAILURE) {
                String logMessages = status.getLogs().stream().map(log -> "[%d][%s] %s".formatted(log.getTime(), log.getLevel(), log.getMessage())).collect(Collectors.joining("\n"));
                throw new IOException("Loading %s failed: %s\nLog messages:\n%s".formatted(file.getAbsolutePath(), status.getStatusMessage(), logMessages));
            }
        }
        catch (ConQATException e) {
            throw new IOException("Could not import backup: " + String.valueOf(file), e);
        }
        return "Successfully loaded: " + String.valueOf(file);
    }

    public static void enableSkipValidationOnBackupImport() {
        skipValidation = true;
    }
}

