/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.analysis_step;

import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@Index(name="sonarlint-finding-cache", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class SonarLintFindingCacheProjectIndex
implements IProjectIndex {
    private final ValueIndex<ArrayList<SonarLintFinding>> delegate;

    public SonarLintFindingCacheProjectIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setFindings(PairList<BasicTokenElementInfo, ArrayList<SonarLintFinding>> findings) throws StorageException {
        PairList values = findings.mapFirst(SonarLintFindingCacheProjectIndex::getContentHash);
        this.delegate.setValues(values);
    }

    public List<ArrayList<SonarLintFinding>> getFindings(List<TokenElementInfo> elements) throws StorageException {
        List hashes = CollectionUtils.map(elements, SonarLintFindingCacheProjectIndex::getContentHash);
        return this.delegate.getValues(hashes);
    }

    private static String getContentHash(BasicTokenElementInfo tokenElement) {
        List<String> content = List.of(tokenElement.getUniformPath(), tokenElement.getText());
        return XXHashUtils.xxhash64(content);
    }
}

