/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum EGitLabIssueType {
    ISSUE("Issue", "I"),
    INCIDENT("Incident", "INC"),
    TASK("Task", "T"),
    UNKNOWN("Unknown", "U");

    private static final Logger LOGGER;
    private final String humanReadable;
    private final String typeAbbreviation;

    private EGitLabIssueType(String humanReadable, String typeAbbreviation) {
        this.humanReadable = humanReadable;
        this.typeAbbreviation = typeAbbreviation;
    }

    @JsonCreator
    public static EGitLabIssueType fromJsonString(String value) {
        return switch (value) {
            case "issue" -> ISSUE;
            case "incident" -> INCIDENT;
            case "task" -> TASK;
            default -> {
                LOGGER.warn("Unknown Issue Type: {}", (Object)value);
                yield UNKNOWN;
            }
        };
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public String getTypeAbbreviation() {
        return this.typeAbbreviation;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

