/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v187_github_allowed_organizations;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

class V187GitHubApplicationDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serverUrl;
    private String appId;
    private String urlName;
    private String privateKey;
    private String webhookSecret;
    private String clientId;
    private String clientSecret;
    private boolean skipCollaboratorCheck;
    private boolean useForSso;
    private String loginButtonDisplayName;
    private boolean createUserOnFirstLogin;
    private String allowedOrganizations;
    private String groups;

    V187GitHubApplicationDescription() {
    }

    public void setAllowedOrganizations(Collection<String> allowedOrganizations) {
        this.allowedOrganizations = StringUtils.concat(allowedOrganizations, (String)", ");
    }

    public List<String> getAllowedOrganizations() {
        if (StringUtils.isEmpty((String)this.allowedOrganizations)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.allowedOrganizations.split(",")).map(String::trim).filter(organization -> !organization.isEmpty()).toList();
    }

    public String getAppId() {
        return this.appId;
    }
}

