/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.OptionScheduledRunnable;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.InstanceIdOption;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.index.monitoring.MonitoringInfo;
import com.teamscale.index.system_info.ESystemHealthCheck;
import com.teamscale.index.system_info.SystemLoadFragment;
import com.teamscale.index.usage_data.InstanceInformationCollectionUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import oshi.SystemInfo;

public class MonitoringDataUploader
extends OptionScheduledRunnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TARGET_URL = "https://monitoring.teamscale.com/";

    public void run() {
        if (!EFeatureToggle.ENABLE_MONITORING_UPLOAD.isEnabled()) {
            LOGGER.warn("Attempting to run monitoring upload although feature is disabled!");
            return;
        }
        try {
            IndexLayer indexLayer = this.getIndexLayer();
            GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
            if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)globalStorageSystem)) {
                return;
            }
            String monitoringInfoJson = MonitoringDataUploader.buildMonitoringInfoJson(indexLayer);
            InstanceInformationCollectionUtils.sendJsonData(monitoringInfoJson, "monitoring", TARGET_URL);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to upload monitoring data", (Throwable)e);
        }
    }

    public static String buildMonitoringInfoJson(IndexLayer indexLayer) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
        String instanceId = InstanceIdOption.getId((ServerOptionIndex)optionIndex);
        MonitoringInfo monitoringInfo = new MonitoringInfo(instanceId);
        MonitoringDataUploader.insertMonitoringMetrics(monitoringInfo, indexLayer);
        return InstanceInformationCollectionUtils.insertCheckSum(JsonUtils.serializeToJSON((Object)monitoringInfo));
    }

    private static void insertMonitoringMetrics(MonitoringInfo monitoringInfo, IndexLayer indexLayer) throws StorageException {
        MonitoringDataUploader.insertFreeRam(monitoringInfo);
        MonitoringDataUploader.insertAvailableDiskSpace(monitoringInfo, indexLayer);
        MonitoringDataUploader.insertJobDuration(monitoringInfo, indexLayer);
    }

    private static void insertFreeRam(MonitoringInfo monitoringInfo) {
        try {
            monitoringInfo.addMetric("ram.available-mb", SystemLoadFragment.getRamAvailableMB(new SystemInfo()));
        }
        catch (Throwable t) {
            LOGGER.error("Failed to collect available RAM information: " + t.getMessage(), t);
        }
    }

    private static void insertAvailableDiskSpace(MonitoringInfo monitoringInfo, IndexLayer indexLayer) throws StorageException {
        ESystemHealthCheck.getPathsToCheck(indexLayer).forEach((name, path) -> {
            try {
                if (Files.exists(path, new LinkOption[0]) && Files.exists(path.toRealPath(new LinkOption[0]), new LinkOption[0])) {
                    monitoringInfo.addMetric("disk." + name + ".available-gb", (double)Files.getFileStore(path.toRealPath(new LinkOption[0])).getUsableSpace() / 1.073741824E9);
                }
            }
            catch (IOException e) {
                LOGGER.error("Skipped data collection for path: " + String.valueOf(path) + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private static void insertJobDuration(MonitoringInfo monitoringInfo, IndexLayer indexLayer) throws StorageException {
        long earliestStart = Long.MAX_VALUE;
        List statuses = ((WorkerIndex)indexLayer.openGlobalIndex(WorkerIndex.class)).getWorkerClusterStatusAccess().listAll();
        for (WorkerClusterStatus status : statuses) {
            for (WorkerClusterStatus.WorkerThreadStatus threadStatus : status.getThreadStatuses()) {
                earliestStart = Math.min(earliestStart, threadStatus.getStartTimestamp());
            }
        }
        double maxDurationSeconds = (double)Math.max(0L, System.currentTimeMillis() - earliestStart) / 1000.0;
        monitoringInfo.addMetric("job.max-duration-seconds", maxDurationSeconds);
    }
}

