/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.monitoring.prometheus;

import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.MetricWithFixedMetadata;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UniqueObservationGauge<T>
extends MetricWithFixedMetadata {
    private final ConcurrentMap<List<String>, DataPoint<T>> data = new ConcurrentHashMap<List<String>, DataPoint<T>>();
    private final Duration interval;

    private UniqueObservationGauge(Builder<T> builder) {
        super(builder);
        this.interval = builder.interval;
    }

    public static <T> Builder<T> builder() {
        return new Builder(PrometheusProperties.get());
    }

    public MetricSnapshot collect() {
        if (this.labelNames.length == 0 && this.data.isEmpty()) {
            this.labelValues(new String[0]);
        }
        ArrayList<Labels> labels = new ArrayList<Labels>(this.data.size());
        ArrayList<DataPoint<T>> metricData = new ArrayList<DataPoint<T>>(this.data.size());
        for (Map.Entry entry : this.data.entrySet()) {
            String[] labelValues = ((List)entry.getKey()).toArray(new String[this.labelNames.length]);
            labels.add(this.constLabels.merge(this.labelNames, labelValues));
            metricData.add((DataPoint)entry.getValue());
        }
        return this.collect(labels, metricData);
    }

    private MetricSnapshot collect(List<Labels> labels, List<DataPoint<T>> metricData) {
        ArrayList<GaugeSnapshot.GaugeDataPointSnapshot> samples = new ArrayList<GaugeSnapshot.GaugeDataPointSnapshot>(metricData.size());
        for (int i = 0; i < labels.size(); ++i) {
            samples.add(metricData.get(i).collect(labels.get(i)));
        }
        return new GaugeSnapshot(this.getMetadata(), samples);
    }

    public DataPoint<T> labelValues(String ... labelValues) {
        if (labelValues.length != this.labelNames.length) {
            if (labelValues.length == 0) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " " + this.getMetadata().getName() + " was created with label names, so you must call labelValues(...) when using it.");
            }
            throw new IllegalArgumentException("Expected " + this.labelNames.length + " label values, but got " + labelValues.length + ".");
        }
        return this.data.computeIfAbsent(Arrays.asList(labelValues), l -> this.newDataPoint());
    }

    private DataPoint<T> newDataPoint() {
        return new DataPoint(this.interval);
    }

    public static class Builder<T>
    extends MetricWithFixedMetadata.Builder<Builder<T>, UniqueObservationGauge<T>> {
        private Duration interval;

        private Builder(PrometheusProperties config) {
            super(Collections.emptyList(), config);
        }

        protected Builder(List<String> illegalLabelNames, PrometheusProperties properties) {
            super(illegalLabelNames, properties);
        }

        public Builder<T> interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public UniqueObservationGauge<T> build() {
            return new UniqueObservationGauge(this);
        }

        protected Builder<T> self() {
            return this;
        }
    }

    public static class DataPoint<T>
    implements GaugeDataPoint {
        private final ConcurrentMap<T, Instant> observations = new ConcurrentHashMap<T, Instant>();
        private final Duration interval;

        private DataPoint(Duration interval) {
            this.interval = interval;
        }

        public void observe(T observation) {
            this.observations.put(observation, Instant.now());
        }

        public void inc(double amount) {
            throw new UnsupportedOperationException("This datapoint can not be incremented. Use observe instead.");
        }

        public void incWithExemplar(double amount, Labels labels) {
            throw new UnsupportedOperationException("This datapoint can not be incremented. Use observe instead.");
        }

        public void set(double value) {
            throw new UnsupportedOperationException("This datapoint can not be set. Use observe instead.");
        }

        public double get() {
            this.observations.values().removeIf(entry -> Duration.between(entry, Instant.now()).compareTo(this.interval) > 0);
            return this.observations.size();
        }

        public void setWithExemplar(double value, Labels labels) {
            throw new UnsupportedOperationException("This datapoint can not be set. Use observe instead.");
        }

        private GaugeSnapshot.GaugeDataPointSnapshot collect(Labels labels) {
            return new GaugeSnapshot.GaugeDataPointSnapshot(this.get(), labels, null);
        }
    }
}

