/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.CheckAnyKeysWithPrefixPresentCallback;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="original-repo-paths", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={String.class})
public class RepositoryOriginalPathIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "original-repo-paths";

    public RepositoryOriginalPathIndex(IStore store) {
        super(store);
    }

    public Map<String, String> getRepositoryPaths(String repositoryIdentifier, String ... uniformPaths) throws StorageException {
        return this.getRepositoryPaths(repositoryIdentifier, Arrays.asList(uniformPaths));
    }

    public Map<String, String> getRepositoryPaths(String repositoryIdentifier, List<String> uniformPaths) throws StorageException {
        List repositoryPaths = this.store.getWithStrings(RepositoryOriginalPathIndex.getKeys(repositoryIdentifier, uniformPaths)).stream().map(StringUtils::bytesToString).collect(Collectors.toList());
        return CollectionUtils.zipAsMap(uniformPaths, repositoryPaths);
    }

    public RepositoryOriginalPathView createView(String repositoryIdentifier) {
        return new RepositoryOriginalPathView(repositoryIdentifier);
    }

    public void addAll(String repositoryIdentifier, Map<String, String> uniformToRepositoryPaths) throws StorageException {
        RepositoryOriginalPathIndex.checkRepositoryIdentifier(repositoryIdentifier);
        this.store.put(new PairList(CollectionUtils.map(uniformToRepositoryPaths, uniformPath -> StringUtils.stringToBytes((String)RepositoryOriginalPathIndex.getKey(repositoryIdentifier, uniformPath)), StringUtils::stringToBytes)));
    }

    public void removeAll(String repositoryIdentifier, String ... uniformPaths) throws StorageException {
        this.removeAll(repositoryIdentifier, Arrays.asList(uniformPaths));
    }

    public void removeAll(String repositoryIdentifier, List<String> uniformPaths) throws StorageException {
        RepositoryOriginalPathIndex.checkRepositoryIdentifier(repositoryIdentifier);
        this.store.removeWithStrings(RepositoryOriginalPathIndex.getKeys(repositoryIdentifier, uniformPaths));
    }

    private static List<String> getKeys(String repositoryIdentifier, List<String> uniformPaths) {
        return uniformPaths.stream().map(uniformPath -> RepositoryOriginalPathIndex.getKey(repositoryIdentifier, uniformPath)).collect(Collectors.toList());
    }

    private static String getKey(String repositoryIdentifier, String uniformPath) {
        return repositoryIdentifier + UniformPathUtils.SEPARATOR + uniformPath;
    }

    private static void checkRepositoryIdentifier(String repositoryIdentifier) {
        Preconditions.checkArgument((!repositoryIdentifier.contains(UniformPathUtils.SEPARATOR) ? 1 : 0) != 0);
    }

    public boolean isFirstCommitOfRepository(String connectorId) throws StorageException {
        CheckAnyKeysWithPrefixPresentCallback checkAnyKeysWithPrefixPresent = new CheckAnyKeysWithPrefixPresentCallback();
        this.store.scanKeys(connectorId, (IKeyValueCallback)checkAnyKeysWithPrefixPresent);
        return !checkAnyKeysWithPrefixPresent.isKeyWithPrefixFound();
    }

    public class RepositoryOriginalPathView {
        private final String repositoryIdentifier;

        private RepositoryOriginalPathView(String repositoryIdentifier) {
            this.repositoryIdentifier = repositoryIdentifier;
        }

        public Map<String, String> getRepositoryPaths(List<String> uniformPaths) throws StorageException {
            return RepositoryOriginalPathIndex.this.getRepositoryPaths(this.repositoryIdentifier, uniformPaths);
        }
    }
}

