/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="timestamp-adjustments", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={Long.class})
public class TimestampAdjustmentIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    public static final String INDEX_NAME = "timestamp-adjustments";
    private static final Logger LOGGER = LogManager.getLogger();

    public TimestampAdjustmentIndex(IStore store) {
        super(store);
    }

    public void adjustTimestamp(long candidateTimestamp, CommitTreeNode commitTreeNode) throws StorageException {
        this.adjustTimestamp(candidateTimestamp, commitTreeNode, false);
    }

    private void adjustTimestamp(long candidateTimestamp, CommitTreeNode commitTreeNode, boolean onlyParentAdjustment) throws StorageException {
        CCSMAssert.isFalse((candidateTimestamp == -1L ? 1 : 0) != 0, (String)("Can't adjust to invalid timestamp for commit tree node: " + String.valueOf(commitTreeNode)));
        CCSMAssert.isTrue((boolean)commitTreeNode.getAdjustedTimestamp().isEmpty(), () -> "Can't adjust timestamp of commit tree node twice: " + String.valueOf(commitTreeNode));
        long maxParentTimestamp = commitTreeNode.getParents().stream().map(CommitTreeNode::getAdjustedTimestamp).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong).max().orElse(0L);
        this.store.performWithLock(() -> {
            String branchName = commitTreeNode.getRevision().getBranchName();
            this.removeMapping(branchName, commitTreeNode);
            long adjustedTimestamp = this.getAdjustedTimestamp(candidateTimestamp, maxParentTimestamp, branchName, onlyParentAdjustment, commitTreeNode.getRevision());
            commitTreeNode.setAdjusted(adjustedTimestamp);
            if (onlyParentAdjustment) {
                LOGGER.debug("Not reserving timestamp '{}' for non-code commit '{}', since the related code commit and other non-code commits are allowed to be adjusted to the same timestamp.", (Object)adjustedTimestamp, (Object)commitTreeNode);
                return;
            }
            LOGGER.debug("Storing adjusted commit '{}'.", (Object)commitTreeNode);
            this.setMapping(branchName, commitTreeNode.getOriginalTimestamp(), adjustedTimestamp);
        });
    }

    private long getAdjustedTimestamp(long candidateTimestamp, long maxParentTimestamp, String branchName, boolean onlyParentAdjustment, CommitTreeRevision revision) throws StorageException {
        if (onlyParentAdjustment) {
            if (maxParentTimestamp >= candidateTimestamp) {
                LOGGER.error("Illegal commit tree state: node {} should be adjusted to {}, but parent already has timestamp {}. Will continue setting adjusted timestamp to parent timestamp + 1. Results will likely be incorrect.", (Object)revision, (Object)candidateTimestamp, (Object)maxParentTimestamp);
            }
            return Math.max(candidateTimestamp, maxParentTimestamp + 1L);
        }
        long candidateAdjustedTimestamp = Math.max(candidateTimestamp, maxParentTimestamp + 1L);
        while (this.getOriginalTimestamp(branchName, candidateAdjustedTimestamp).isPresent()) {
            ++candidateAdjustedTimestamp;
        }
        return candidateAdjustedTimestamp;
    }

    private void removeMapping(String branchName, CommitTreeNode commitTreeNode) throws StorageException {
        OptionalLong adjustedTimestamp = commitTreeNode.getAdjustedTimestamp();
        if (adjustedTimestamp.isEmpty()) {
            return;
        }
        this.store.remove(TimestampAdjustmentIndex.createKey(branchName, adjustedTimestamp.getAsLong()));
    }

    void setMapping(String branchName, long originalTimestamp, long adjustedTimestamp) throws StorageException {
        this.store.put(TimestampAdjustmentIndex.createKey(branchName, adjustedTimestamp), ByteArrayUtils.longToByteArray((long)originalTimestamp));
    }

    public OptionalLong getOriginalTimestamp(String branchName, long adjustedTimestamp) throws StorageException {
        return ByteArrayUtils.byteArrayToOptionalLong((byte[])this.store.get(TimestampAdjustmentIndex.createKey(branchName, adjustedTimestamp)));
    }

    private static byte[] createKey(String branchName, long adjustedTimestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)branchName), ByteArrayUtils.longToByteArray((long)adjustedTimestamp)});
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        this.store.performWithLock(() -> {
            ArrayList keysToDelete = new ArrayList();
            for (String branch : timestampByBranch.keySet()) {
                long leastTimestampToRollback = (Long)timestampByBranch.get(branch) + 1L;
                byte[] beginKey = TimestampAdjustmentIndex.createKey(branch, leastTimestampToRollback);
                byte[] endKey = TimestampAdjustmentIndex.createKey(branch, Long.MAX_VALUE);
                this.store.scanKeys(beginKey, endKey, (key, value) -> {
                    if (beginKey.length == key.length) {
                        List list = keysToDelete;
                        synchronized (list) {
                            keysToDelete.add(key);
                        }
                    }
                });
            }
            this.store.remove(keysToDelete);
        });
    }

    public void adjustTimestampToOriginal(long originalTimestamp, CommitTreeNode commitTreeNode) throws StorageException {
        this.adjustTimestamp(originalTimestamp, commitTreeNode, true);
    }
}

