/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class GitBranchRetriever
implements IBranchRetriever {
    protected final ServerOptionIndex serverOptionIndex;
    private final String repositoryNameOrPathSuffix;

    public GitBranchRetriever(ServerOptionIndex serverOptionIndex, String repositoryDescription) {
        this.serverOptionIndex = serverOptionIndex;
        this.repositoryNameOrPathSuffix = repositoryDescription;
    }

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        return this.fetchBranchesAtUri(credentials, connectorConfiguration, GitRepositoryConnector.adjustGitUrlAndConvertToUri(this.getRepositoryUri(credentials, connectorConfiguration), this.repositoryNameOrPathSuffix));
    }

    protected String getRepositoryUri(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        return credentials.uri;
    }

    protected Set<String> fetchBranchesAtUri(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration, URI repositoryUri) throws RepositoryException, ProjectConfigurationException {
        EGitProtocol protocol = GitPreviewUtils.getGitProtocol(repositoryUri);
        if (protocol == EGitProtocol.FILE) {
            return GitBranchRetriever.getBranchesFromLocalGitRepository(repositoryUri);
        }
        String sshPrivateKeyId = connectorConfiguration.getOptionValue("SSH Private Key ID");
        TeamscaleGitCredentialsProvider credentialsProvider = GitPreviewUtils.getCredentialsProvider(this.serverOptionIndex, protocol, credentials, sshPrivateKeyId);
        return GitBranchRetriever.getGitBranches(repositoryUri, credentialsProvider);
    }

    private static Set<String> getBranchesFromLocalGitRepository(URI uri) throws RepositoryException {
        Set<String> branches = GitBranchRetriever.getRefs(uri).stream().map(ref -> {
            String branchName = ref.getName();
            if (branchName.startsWith("refs/remotes/origin/")) {
                return StringUtils.stripPrefix((String)branchName, (String)"refs/remotes/origin/");
            }
            if (branchName.startsWith("refs/heads/")) {
                return StringUtils.stripPrefix((String)branchName, (String)"refs/heads/");
            }
            return branchName;
        }).collect(Collectors.toSet());
        branches.remove("HEAD");
        return branches;
    }

    private static Collection<Ref> getRefs(URI uri) throws RepositoryException {
        List list;
        Git git = new Git(GitUtils.getExistingLocalRepository(uri));
        try {
            list = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (GitAPIException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        git.close();
        return list;
    }

    public static Set<String> getGitBranches(URI uri, String username, String installationToken) throws RepositoryException {
        return GitBranchRetriever.getGitBranches(uri, GitUtils.createCredentialsProvider(username, installationToken, null));
    }

    public static Optional<Ref> getRefForGitBranch(String branchName, URI uri, TeamscaleGitCredentialsProvider credentialsProvider) throws RepositoryException {
        return GitBranchRetriever.getHeadRefs(Git.lsRemoteRepository(), uri, credentialsProvider).stream().filter(ref -> StringUtils.stripPrefix((String)ref.getName(), (String)"refs/heads/").equals(branchName)).findAny();
    }

    private static Set<String> getGitBranches(URI uri, TeamscaleGitCredentialsProvider credentialsProvider) throws RepositoryException {
        return GitBranchRetriever.getHeadRefs(Git.lsRemoteRepository(), uri, credentialsProvider).stream().map(ref -> StringUtils.stripPrefix((String)ref.getName(), (String)"refs/heads/")).collect(Collectors.toSet());
    }

    private static Collection<Ref> getHeadRefs(LsRemoteCommand lsRemoteCommand, URI uri, TeamscaleGitCredentialsProvider credentialsProvider) throws RepositoryException {
        try {
            return GitUtils.configureCommand(uri, credentialsProvider, lsRemoteCommand.setHeads(true).setRemote(uri.toString()), ICancelable.neverCanceled()).call();
        }
        catch (GitAPIException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

