/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.util.regex.Pattern;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="git.privatekey", name="Git Private Key", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.GIT, orderingHint=2000)
@IndexValueClass(containedInBackup=true)
public class GitPrivateKeyOption
implements IOption {
    private static final Pattern PRIVATE_KEY_FORMAT = Pattern.compile("-----BEGIN ((OPENSSH|RSA|ENCRYPTED) )?PRIVATE KEY-----");
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "git.privatekey";
    public static final String OPTION_NAME = "Git Private Key";
    @JsonProperty(value="privateKey")
    @MultilineOption
    @OptionFieldDescription(name="Private Key", description="The private key used to connect to the Git server")
    public String privateKey = "";
    @JsonProperty(value="privateKeyPassphrase")
    @PasswordOption
    @OptionFieldDescription(name="Private Key Passphrase", description="The passphrase used to unlock the private key")
    public @Nullable String privateKeyPassphrase = null;

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (!PRIVATE_KEY_FORMAT.matcher(this.privateKey).find()) {
            return "Selected key is not a valid private key.";
        }
        return null;
    }
}

