/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.tfs.TfsRepositoryConnectorDescriptor;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import com.teamscale.index.repository.tfs.client.IAzureDevOpsTfvcRestApi;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import com.teamscale.index.repository.tfs.client.model.TfvcChangeDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangesetDto;
import com.teamscale.index.repository.tfs.client.model.TfvcItemDto;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TfsRevisionResolver
implements IRevisionResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExternalCredentials credentials;
    private final TfsRepositoryConnectorDescriptor tfsConnectorDescriptor;
    private final boolean enableBranchAnalysis;
    private final String pathSuffix;
    private final List<String> branchLookupPaths;

    public TfsRevisionResolver(ExternalCredentials credentials, TfsRepositoryConnectorDescriptor tfsConnectorDescriptor, boolean enableBranchAnalysis, String pathSuffix, List<String> branchLookupPaths) {
        this.credentials = credentials;
        this.tfsConnectorDescriptor = tfsConnectorDescriptor;
        this.enableBranchAnalysis = enableBranchAnalysis;
        this.pathSuffix = pathSuffix;
        this.branchLookupPaths = branchLookupPaths;
    }

    @Override
    public Optional<CommitDescriptor> resolveToCommitDescriptor(String revision) {
        try {
            TfsHttpConnection tfsHttpConnection = new TfsHttpConnection(this.credentials, HttpRequestRetryPolicy.SYSTEM_DEFAULT, LOGGER);
            IAzureDevOpsTfvcRestApi tfvcVersionControlClient = tfsHttpConnection.createAzureDevOpsTfvcRestClient();
            TfvcChangesetDto tfsCommit = tfvcVersionControlClient.getChangeset(Integer.parseInt(revision), 0);
            if (tfsCommit == null) {
                return Optional.empty();
            }
            return Optional.of(new CommitDescriptor(this.determineBranchName(tfvcVersionControlClient, tfsCommit), tfsCommit.getDate().getTime()));
        }
        catch (ServiceCallException | RepositoryException e) {
            LOGGER.warn("Could not resolve revision: {}", (Object)revision, (Object)e);
            return Optional.empty();
        }
    }

    private String determineBranchName(IAzureDevOpsTfvcRestApi tfvcVersionControlClient, TfvcChangesetDto tfsCommit) throws RepositoryException, ServiceCallException {
        if (!this.enableBranchAnalysis) {
            return this.tfsConnectorDescriptor.getDefaultBranchName();
        }
        Set<String> branches = TfsRepositoryUtils.listBranchesForPaths(tfvcVersionControlClient, this.pathSuffix, TfsRepositoryUtils.filterCommentedPaths(this.branchLookupPaths), new IncludeExcludeRegexSupport(), false);
        String branchName = null;
        List<TfvcChangeDto> changesForChangeset = tfvcVersionControlClient.getChangesForChangeset(tfsCommit.getChangesetId(), 0x7FFFFFFE).getChanges();
        for (TfvcChangeDto change : changesForChangeset) {
            Optional<String> optionalBranchNameFromItem = this.getBranchNameFromItem(branches, change.getItem());
            if (optionalBranchNameFromItem.isEmpty()) continue;
            String branchNameFromItem = optionalBranchNameFromItem.get();
            if (StringUtils.isEmpty(branchName)) {
                branchName = branchNameFromItem;
                continue;
            }
            if (branchName.equals(branchNameFromItem)) continue;
            LOGGER.warn("This TFS change-set has multiple branch names: " + branchName + " and " + branchNameFromItem + ". Change-Set ID: " + tfsCommit.getChangesetId() + ". Using default branch");
            return this.tfsConnectorDescriptor.getDefaultBranchName();
        }
        if (StringUtils.isEmpty(branchName)) {
            return this.tfsConnectorDescriptor.getDefaultBranchName();
        }
        return branchName;
    }

    private Optional<String> getBranchNameFromItem(Set<String> branches, TfvcItemDto item) {
        String itemParentFolderPath = StringUtils.stripPrefix((String)item.getPath(), (String)(this.pathSuffix + UniformPathUtils.SEPARATOR));
        for (String branch : branches) {
            if (!itemParentFolderPath.startsWith(branch)) continue;
            return Optional.of(branch);
        }
        return Optional.empty();
    }
}

