/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.gitlab;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.gitlab.GitLabSynchronizerBase;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssue;
import com.teamscale.index.issues.gitlab.client.model.GitLabUser;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import java.util.Collections;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class GitLabSpecItemSynchronizer
extends GitLabSynchronizerBase<SpecItem> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SpecItemHistoryIndex specItemHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="spec-items")
    protected SpecItemIndex previousIssueIndex;

    @Override
    protected SpecItem createIssue(GitLabIssue gitlabIssue, long startTimestamp) {
        TeamscaleIssue teamscaleIssue = this.createTeamscaleIssue(gitlabIssue, startTimestamp);
        return new SpecItem(teamscaleIssue, gitlabIssue.assignees().stream().skip(1L).map(GitLabUser::username).toList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), gitlabIssue.issueType().getHumanReadable(), gitlabIssue.issueType().getTypeAbbreviation());
    }

    @Override
    protected IIssueHistoryIndex<SpecItem> getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousIssueIndex;
    }
}

