/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@IndexValueClass
public class SimulinkModelInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final List<String> blockIds = new ArrayList<String>();

    public SimulinkModelInfo(SimulinkModel model) {
        this.modelName = model.getName();
        this.blockIds.addAll(CollectionUtils.map((Collection)SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)true, (boolean)true), SimulinkElementBase::getId));
        if (model.getStateflowMachine() != null) {
            for (StateflowChart chart : model.getStateflowMachine().getCharts()) {
                this.listChartElements(chart);
            }
        }
        Collections.sort(this.blockIds);
    }

    private void listChartElements(StateflowChart chart) {
        this.listNodes(chart, (Collection<StateflowNodeBase>)chart.getNodes());
        for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart)) {
            this.blockIds.add(transition.buildQualifiedName());
        }
    }

    private void listNodes(StateflowChart chart, Collection<StateflowNodeBase> nodes) {
        for (StateflowNodeBase node : nodes) {
            this.blockIds.add(node.buildQualifiedName());
            if (!(node instanceof StateflowState)) continue;
            this.listNodes(chart, (Collection<StateflowNodeBase>)((StateflowState)node).getNodes());
            if (!((StateflowState)node).isSubChart()) continue;
            this.listChartElements(((StateflowState)node).getSubViewer());
        }
    }

    public String getModelName() {
        return this.modelName;
    }

    public List<String> getBlockIds() {
        return this.blockIds;
    }
}

