/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.IPathLookupIndex;
import com.teamscale.index.resource.path_lookup.LongestMatchingSuffixPathsCollector;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Index(name="path-lookup", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class PathLookupIndex
implements IPathLookupIndex,
IMatchingPathsLookup {
    public static final String INDEX_NAME = "path-lookup";
    private final ValueIndex<String> delegate;
    private final Double pathSuffixSizeRatioThresholdOverwrite;

    public PathLookupIndex(IStore store) {
        this(store, null);
    }

    public PathLookupIndex(IStore store, Double pathSuffixSizeRatioThresholdOverwrite) {
        this.pathSuffixSizeRatioThresholdOverwrite = pathSuffixSizeRatioThresholdOverwrite;
        this.delegate = ValueIndex.forString((IStore)store);
    }

    public void addPaths(Collection<String> uniformPaths) throws StorageException {
        PairList pairs = new PairList();
        for (String uniformPath : uniformPaths) {
            String reversedPath = PathLookupUtils.normalizeAndReversePathEnsureEnding(uniformPath);
            pairs.add((Object)reversedPath, (Object)PathLookupUtils.stripLeadingSlash(uniformPath));
        }
        this.delegate.setValues(pairs);
    }

    public void removePaths(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues((Collection)CollectionUtils.map(uniformPaths, PathLookupUtils::normalizeAndReversePathEnsureEnding));
    }

    @Override
    public ImmutableList<String> lookupSuffix(String suffix) {
        try {
            PairList entries = this.delegate.getEntriesStartingWith(PathLookupUtils.normalizeAndReversePath(suffix));
            return ImmutableList.copyOf((Collection)entries.extractSecondList());
        }
        catch (StorageException e) {
            LOGGER.error("StorageException while looking up UniformPaths for path suffix {}", (Object)suffix, (Object)e);
            return ImmutableList.of();
        }
    }

    @Override
    public Optional<Pair<String, ImmutableList<String>>> lookupPath(String path, @NonNull PathLookupOptions options) {
        PairList reversedPathsAndCandidatePaths;
        if (path == null) {
            return Optional.empty();
        }
        String normalizedPathReversed = PathLookupUtils.normalizeAndReversePathEnsureEnding(path);
        int firstSeparatorIndex = normalizedPathReversed.indexOf(47);
        Preconditions.checkState((firstSeparatorIndex >= 0 ? 1 : 0) != 0, (Object)"Normalization must yield reversed path with a separator at the end.");
        String reversedFileNameWithSlash = normalizedPathReversed.substring(0, firstSeparatorIndex + 1);
        try {
            reversedPathsAndCandidatePaths = this.delegate.getEntriesStartingWith(reversedFileNameWithSlash);
        }
        catch (StorageException e) {
            LOGGER.error("StorageException while looking up UniformPaths for path {}", (Object)path, (Object)e);
            return Optional.empty();
        }
        LongestMatchingSuffixPathsCollector longestMatchingSuffixPathsCollector = new LongestMatchingSuffixPathsCollector(normalizedPathReversed, options.shouldExcludePathsWhereOnlyFileNameMatches());
        reversedPathsAndCandidatePaths.forEach((keyPath, originalPath) -> longestMatchingSuffixPathsCollector.collectPath((String)keyPath, Collections.singletonList(originalPath)));
        Pair lookupResult = longestMatchingSuffixPathsCollector.getLookupResult(path).orElse(null);
        if (lookupResult == null) {
            return Optional.empty();
        }
        return Optional.of(PathLookupUtils.applyPlausibilityLookupOptions(path, options, (Pair<String, ImmutableList<String>>)lookupResult));
    }

    @Override
    public ImmutableList<String> lookupAllPaths(String path, @NonNull PathLookupOptions options) {
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(path, options);
        if (lookupResultOptional.isEmpty()) {
            return ImmutableList.of();
        }
        return (ImmutableList)lookupResultOptional.get().getSecond();
    }

    @Override
    public Optional<String> lookupBestPath(String path, @NonNull PathLookupOptions options) {
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(path, options);
        if (lookupResultOptional.isEmpty()) {
            return Optional.empty();
        }
        return PathLookupUtils.determineHighestScoringMatch(path, lookupResultOptional.get(), this.getPathSuffixSizeRatioThreshold());
    }

    @Override
    public PairList<String, String> getEntries() throws StorageException {
        return this.delegate.getEntriesStartingWith("");
    }

    public void removeAllEntries() throws StorageException {
        this.delegate.removeAllEntries();
    }

    @Override
    public double getPathSuffixSizeRatioThreshold() {
        return Objects.requireNonNullElseGet(this.pathSuffixSizeRatioThresholdOverwrite, () -> IPathLookupIndex.super.getPathSuffixSizeRatioThreshold());
    }

    public List<String> lookupByFileNamePart(String fileNamePart) {
        try {
            return this.delegate.getAllEntries().extractSecondList().stream().filter(path -> StringUtils.containsIgnoreCase((String)UniformPathUtils.getElementName((String)path), (String)fileNamePart)).toList();
        }
        catch (StorageException e) {
            LOGGER.error("StorageException while looking up UniformPaths for path {}", (Object)fileNamePart, (Object)e);
            return new ArrayList<String>();
        }
    }
}

