/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.metrics.MetricNames;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.SchemaChangingRetrievalStrategyBase;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.jspecify.annotations.NonNull;

public class MetricReorderingRetrievalStrategy
extends SchemaChangingRetrievalStrategyBase {
    private static final UnmodifiableMap<String, Integer> CODE_METRICS_DEFAULT_ORDER = MetricReorderingRetrievalStrategy.buildMetricOrdering(List.of("Files", "Lines of Code", "Source Lines of Code", "File Size Assessment", "Longest Method Length", "Method Length Assessment", "Maximum Nesting Depth", "Nesting Depth Assessment", "Maximum Cyclomatic Complexity", "Cyclomatic Complexity Assessment", "Language", "Last Change Date", "Change Count", "Number of Findings", MetricNames.FINDINGS_COUNT_RED.getName(), MetricNames.FINDINGS_COUNT_YELLOW.getName(), MetricNames.FINDINGS_DENSITY.getName(), MetricNames.FINDINGS_DENSITY_RED.getName(), MetricNames.FINDINGS_DENSITY_YELLOW.getName(), "Clone Coverage", "Comment Completeness Assessment", "Line Coverage"));
    private final UnmodifiableMap<String, Integer> metricOrdering;

    private MetricReorderingRetrievalStrategy(UnmodifiableMap<String, Integer> metricOrdering, IMetricRetrievalStrategy delegate) {
        super(delegate);
        this.metricOrdering = metricOrdering;
    }

    public static MetricReorderingRetrievalStrategy codeMetricsDefaultOrder(IMetricRetrievalStrategy delegate) {
        return new MetricReorderingRetrievalStrategy(CODE_METRICS_DEFAULT_ORDER, delegate);
    }

    public static MetricReorderingRetrievalStrategy withOrder(List<String> metrics, IMetricRetrievalStrategy delegate) {
        return new MetricReorderingRetrievalStrategy(MetricReorderingRetrievalStrategy.buildMetricOrdering(metrics), delegate);
    }

    private static @NonNull UnmodifiableMap<String, Integer> buildMetricOrdering(List<String> metricOrdering) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int index = 0;
        for (String metric : metricOrdering) {
            if (result.containsKey(metric)) continue;
            result.put(metric, index++);
        }
        return CollectionUtils.asUnmodifiable(result);
    }

    @Override
    protected MetricDirectorySchema updateSchema(MetricDirectorySchema schema) {
        return new MetricDirectorySchema(schema.getAllEntries().stream().sorted(this.getEntryComparator(schema)).toList());
    }

    private Comparator<MetricDirectorySchemaEntry> getEntryComparator(MetricDirectorySchema schema) {
        return Comparator.comparing(MetricDirectorySchemaEntry::getName, this.getMetricComparator(schema));
    }

    private Comparator<String> getMetricComparator(MetricDirectorySchema schema) {
        return Comparator.comparingInt(metricName -> Objects.requireNonNullElseGet((Integer)this.metricOrdering.get(metricName), () -> schema.getValuePosition(metricName) + this.metricOrdering.size()));
    }

    @Override
    protected UnaryOperator<Object[]> getMetricsUpdaterForSchema(MetricDirectorySchema schema) {
        MetricDirectorySchema orderedSchema = this.updateSchema(schema);
        int[] targetIndex = new int[schema.size()];
        int index = 0;
        for (MetricDirectorySchemaEntry entry : schema.getAllEntries()) {
            targetIndex[index++] = orderedSchema.getValuePosition(entry.getName());
        }
        return metrics -> {
            Object[] resultMetrics = new Object[((Object[])metrics).length];
            for (int i = 0; i < ((Object[])metrics).length; ++i) {
                resultMetrics[targetIndex[i]] = metrics[i];
            }
            return resultMetrics;
        };
    }
}

