/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.SimulinkModelInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class DerivedTestCoverageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="infos")
    private final List<ElementCoverageInfo> infos = new ArrayList<ElementCoverageInfo>();
    private transient Map<String, ElementCoverageInfo> idToInfo;

    public void removeSourceFiles(Set<String> deletedFiles) {
        this.infos.forEach(info -> info.removeSourceFiles(deletedFiles));
        this.idToInfo = null;
    }

    public void adjustToModel(SimulinkModelInfo modelInfo) {
        HashSet<String> allBlockIds = new HashSet<String>(modelInfo.getBlockIds());
        allBlockIds.add(modelInfo.getModelName());
        this.infos.removeIf(info -> !allBlockIds.contains(info.elementId));
        allBlockIds.removeAll(new HashSet(CollectionUtils.map(this.infos, info -> info.elementId)));
        for (String id : allBlockIds) {
            this.infos.add(new ElementCoverageInfo(id));
        }
        this.idToInfo = null;
    }

    public void insertSourceLocation(String elementId, TextRegionLocation location) {
        ElementCoverageInfo info = this.getInfo(elementId);
        if (info != null) {
            info.mappedLocations.add(location);
        }
    }

    private ElementCoverageInfo getInfo(String elementId) {
        this.ensureIdToInfo();
        return this.idToInfo.get(elementId);
    }

    private void ensureIdToInfo() {
        if (this.idToInfo == null) {
            this.idToInfo = this.infos.stream().collect(Collectors.toMap(ElementCoverageInfo::getElementId, x -> x));
        }
    }

    public Stream<String> getSourceUniformPathAsStream() {
        return this.infos.stream().flatMap(info -> info.mappedLocations.stream()).map(ElementLocation::getUniformPath);
    }

    public void recalculateCoverage(Map<String, LineCoverageInfo> sourcePathToCoverageInfo) {
        for (ElementCoverageInfo info : this.infos) {
            info.coverableLineLocations = new HashSet<String>();
            info.coveredLineLocations = new HashSet<String>();
            info.compactMappedLocations();
        }
        this.ensureIdToInfo();
        for (ElementCoverageInfo info : this.infos) {
            List<ElementCoverageInfo> affected = this.getAffectedInfos(info);
            for (TextRegionLocation location : info.mappedLocations) {
                DerivedTestCoverageInfo.updateAffectedForLocation(affected, location, sourcePathToCoverageInfo);
            }
        }
        for (ElementCoverageInfo info : this.infos) {
            info.coverableLines = info.coverableLineLocations.size();
            info.coveredLines = info.coveredLineLocations.size();
        }
    }

    private static void updateAffectedForLocation(List<ElementCoverageInfo> affected, TextRegionLocation location, Map<String, LineCoverageInfo> sourcePathToCoverageInfo) {
        LineCoverageInfo coverageInfo = sourcePathToCoverageInfo.get(location.getUniformPath());
        block4: for (int line = location.getRawStartLine(); line <= location.getRawEndLine(); ++line) {
            ELineCoverage coverage = coverageInfo.getLineCoverage(line);
            if (coverage == null) continue;
            String locationString = location.getUniformPath() + ":" + line;
            switch (coverage) {
                case FULLY_COVERED: 
                case PARTIALLY_COVERED: {
                    affected.forEach(info -> info.coveredLineLocations.add(locationString));
                }
                case NOT_COVERED: {
                    affected.forEach(info -> info.coverableLineLocations.add(locationString));
                    continue block4;
                }
            }
        }
    }

    private List<ElementCoverageInfo> getAffectedInfos(ElementCoverageInfo info) {
        ArrayList<ElementCoverageInfo> affected = new ArrayList<ElementCoverageInfo>();
        affected.add(info);
        ElementCoverageInfo nestedInfo = info;
        while (nestedInfo != null && nestedInfo.getElementId().contains("/")) {
            if ((nestedInfo = this.idToInfo.get(StringUtils.removeLastPart((String)nestedInfo.getElementId(), (char)'/'))) == null) continue;
            affected.add(nestedInfo);
        }
        return affected;
    }

    public void sort() {
        Collections.sort(this.infos);
        for (ElementCoverageInfo info : this.infos) {
            Collections.sort(info.mappedLocations, Comparator.comparing(TextRegionLocation::toLocationString));
        }
    }

    public int getFirstInfoCoverableLines() {
        if (this.infos.isEmpty()) {
            return 0;
        }
        return this.infos.get((int)0).coverableLines;
    }

    public int getFirstInfoCoveredLines() {
        if (this.infos.isEmpty()) {
            return 0;
        }
        return this.infos.get((int)0).coveredLines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ElementCoverageInfo info : this.infos) {
            builder.append(info.toString()).append("\n");
        }
        return builder.toString();
    }

    @IndexValueClass
    private static class ElementCoverageInfo
    implements Serializable,
    Comparable<ElementCoverageInfo> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="elementId")
        private final String elementId;
        @JsonProperty(value="coverableLines")
        private int coverableLines;
        @JsonProperty(value="coveredLines")
        private int coveredLines;
        @JsonProperty(value="mappedLocations")
        private final List<TextRegionLocation> mappedLocations = new ArrayList<TextRegionLocation>();
        private transient Set<String> coverableLineLocations;
        private transient Set<String> coveredLineLocations;

        public ElementCoverageInfo(String elementId) {
            this.elementId = elementId;
        }

        public void removeSourceFiles(Set<String> deletedFiles) {
            this.mappedLocations.removeIf(location -> deletedFiles.contains(location.getUniformPath()));
        }

        @Override
        public int compareTo(ElementCoverageInfo other) {
            return this.elementId.compareTo(other.elementId);
        }

        public String getElementId() {
            return this.elementId;
        }

        public void compactMappedLocations() {
            List copy = CollectionUtils.sort(this.mappedLocations, Comparator.comparing(ElementLocation::getUniformPath).thenComparingInt(TextRegionLocation::getRawStartLine));
            this.mappedLocations.clear();
            TextRegionLocation previousLocation = null;
            for (TextRegionLocation location : copy) {
                if (previousLocation != null && ElementCoverageInfo.canJoinLocations(previousLocation, location)) {
                    previousLocation = ElementCoverageInfo.extendLocation(previousLocation, location);
                    this.mappedLocations.remove(this.mappedLocations.size() - 1);
                } else {
                    previousLocation = location;
                }
                this.mappedLocations.add(previousLocation);
            }
        }

        private static boolean canJoinLocations(TextRegionLocation previousLocation, TextRegionLocation location) {
            return previousLocation.getUniformPath().equals(location.getUniformPath()) && previousLocation.getRawEndLine() + 1 >= location.getRawStartLine();
        }

        private static TextRegionLocation extendLocation(TextRegionLocation previousLocation, TextRegionLocation location) {
            return new TextRegionLocation(previousLocation.getUniformPath(), -1, -1, previousLocation.getRawStartLine(), location.getRawEndLine());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.elementId).append(": ").append(this.coveredLines).append("/").append(this.coverableLines);
            for (TextRegionLocation location : this.mappedLocations) {
                builder.append("\n  ").append(location.toLocationString());
            }
            return builder.toString();
        }
    }
}

