/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.index.testimpact.TestImplementation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="tests", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TestImplementationIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "tests";
    private final ValueIndex<TestImplementation> delegate;

    public TestImplementationIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public Map<UniformPath, TestImplementation> getAllTestImplementations() throws StorageException {
        return this.delegate.getAllEntries().mapFirst(UniformPathCompatibilityUtil::convert).toMap();
    }

    public TestImplementation getTestImplementation(UniformPath uniformPath) throws StorageException {
        return (TestImplementation)this.delegate.getValue(uniformPath.toString());
    }

    public List<TestImplementation> getTestImplementations(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public List<@Nullable TestImplementation> getTestImplementationsForPaths(List<UniformPath> uniformPaths) throws StorageException {
        return this.getTestImplementations(CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    public void setTestImplementation(CommitDescriptor lastChangedCommit, PairList<UniformPath, TestImplementation> uniformPathsAndTestImplementations) throws StorageException {
        PairList uniformPathsAndTestImplementationsToUpdate = new PairList();
        List previousValues = this.delegate.getValues(CollectionUtils.map((Collection)uniformPathsAndTestImplementations.extractFirstList(), UniformPath::toString));
        for (int i = 0; i < uniformPathsAndTestImplementations.size(); ++i) {
            UniformPath uniformPath = (UniformPath)uniformPathsAndTestImplementations.getFirst(i);
            TestImplementation testImplementation = (TestImplementation)uniformPathsAndTestImplementations.getSecond(i);
            TestImplementation predecessor = (TestImplementation)previousValues.get(i);
            if (predecessor != null && !TestImplementationIndex.hasChanged(predecessor, testImplementation)) continue;
            if (predecessor == null || TestImplementationIndex.hasImplementationChanged(testImplementation, predecessor)) {
                testImplementation.setLastImplementationHashChangedTimestamp(lastChangedCommit.getTimestamp());
            } else {
                testImplementation.setLastImplementationHashChangedTimestamp(predecessor.getLastImplementationHashChangedTimestamp());
            }
            uniformPathsAndTestImplementationsToUpdate.add((Object)uniformPath.toString(), (Object)testImplementation);
        }
        this.delegate.setValues(uniformPathsAndTestImplementationsToUpdate);
    }

    private static boolean hasChanged(@NonNull TestImplementation predecessor, @NonNull TestImplementation testImplementation) {
        return TestImplementationIndex.hasImplementationChanged(testImplementation, predecessor) || TestImplementationIndex.hasPropertiesChanged(testImplementation, predecessor) || TestImplementationIndex.hasLocationChanged(testImplementation, predecessor);
    }

    private static boolean hasImplementationChanged(TestImplementation testImplementation, @NonNull TestImplementation predecessor) {
        return !Objects.equals(testImplementation.getImplementationHash(), predecessor.getImplementationHash());
    }

    private static boolean hasPropertiesChanged(TestImplementation testImplementation, @NonNull TestImplementation predecessor) {
        return !Objects.equals(testImplementation.getProperties(), predecessor.getProperties());
    }

    private static boolean hasLocationChanged(TestImplementation testImplementation, @NonNull TestImplementation predecessor) {
        return !Objects.equals(testImplementation.getLocation(), predecessor.getLocation()) || !Objects.equals(testImplementation.getLocationWithComment(), predecessor.getLocationWithComment());
    }

    public void removeTestImplementations(List<String> deletedTests) throws StorageException {
        this.delegate.removeValues(deletedTests);
    }

    public List<String> getAllTestUniformPaths() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public void setTestImplementation(String testUniformPath, TestImplementation testImplementation) throws StorageException {
        this.delegate.setValue(testUniformPath, (Object)testImplementation);
    }
}

