/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.information_retrieval.data;

import com.teamscale.commons.TextResourceLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class StopWordSet {
    private static final Pattern STOP_WORD_LIST_SPLIT_PATTERN = Pattern.compile("[,\\r?\\n]+");
    private static final Map<ELanguage, Set<String>> LANGUAGE_STOP_WORDS = new ConcurrentHashMap<ELanguage, Set<String>>();

    public static boolean shouldIgnore(String term, ELanguage language) {
        return StopWordSet.getWordSetForLanguage(language).contains(term.toLowerCase());
    }

    private static Set<String> getWordSetForLanguage(ELanguage language) {
        Set<String> result = LANGUAGE_STOP_WORDS.get(language);
        if (result == null) {
            Optional stopWordList;
            result = new HashSet<String>();
            String languageName = language.name().toLowerCase();
            if (language == ELanguage.TEXT || language == ELanguage.NL_REQUIREMENTS || language == ELanguage.NL_TESTS || language == ELanguage.NL_ISSUES) {
                languageName = "english";
            }
            if ((stopWordList = StopWordSet.getStopWordListLoader().getTextResource(StopWordSet.class, languageName + ".txt")).isPresent()) {
                result.addAll(Arrays.stream(STOP_WORD_LIST_SPLIT_PATTERN.split((CharSequence)stopWordList.get())).map(String::trim).map(String::toLowerCase).toList());
            }
            LANGUAGE_STOP_WORDS.put(language, result);
        }
        return result;
    }

    private static TextResourceLoader getStopWordListLoader() {
        return new TextResourceLoader("stop-words");
    }
}

