/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.index;

import com.teamscale.index.tracking.index.FindingSerializationUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="tracked-findings-by-id", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class TrackedFindingsByIdIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "tracked-findings-by-id";
    private final ValueIndex<TrackedFinding> delegate;

    public TrackedFindingsByIdIndex(IStore store) {
        this.delegate = ValueIndex.of((IStore)store, FindingSerializationUtils.FINDING_SERIALIZER);
    }

    public void insertOrUpdateFindings(Collection<TrackedFinding> findings) throws StorageException {
        PairList keysValues = new PairList();
        for (TrackedFinding finding : findings) {
            keysValues.add((Object)finding.getId(), (Object)finding);
        }
        this.delegate.setValues(keysValues);
    }

    public <T extends TrackedFinding> void updateDeathCommits(Collection<T> trackedFindings) throws StorageException {
        this.updateFindingProperties(trackedFindings, TrackedFindingsByIdIndex::updateDeathCommitIfSet);
    }

    public static void updateDeathCommitIfSet(TrackedFinding oldFinding, TrackedFinding currentFinding) {
        if (currentFinding.getDeathCommit() != null) {
            oldFinding.setDeathCommit(currentFinding.getDeathCommit());
        }
    }

    public <T extends TrackedFinding> void updateFindingProperties(Collection<T> trackedFindings, BiConsumer<T, TrackedFinding> updateFunction) throws StorageException {
        if (CollectionUtils.isNullOrEmpty(trackedFindings)) {
            return;
        }
        List findingIds = trackedFindings.stream().filter(Objects::nonNull).map(TrackedFinding::getId).distinct().collect(Collectors.toList());
        HashMap<String, TrackedFinding> currentFindingsById = new HashMap<String, TrackedFinding>();
        for (TrackedFinding finding : this.delegate.getValues(findingIds)) {
            if (finding == null) continue;
            currentFindingsById.put(finding.getId(), finding);
        }
        trackedFindings.stream().filter(Objects::nonNull).forEach(oldFinding -> {
            TrackedFinding currentFinding = (TrackedFinding)currentFindingsById.get(oldFinding.getId());
            if (currentFinding != null) {
                updateFunction.accept(oldFinding, currentFinding);
            }
        });
    }

    public @Nullable TrackedFinding getFinding(@NonNull String findingId) throws StorageException {
        return (TrackedFinding)this.delegate.getValue(findingId);
    }

    public List<@Nullable TrackedFinding> getFindings(List<String> findingIds) throws StorageException {
        return this.delegate.getValues(findingIds);
    }

    public void removeFindings(Collection<String> findingIds) throws StorageException {
        this.delegate.removeValues(findingIds);
    }

    public List<TrackedFinding> getAllFindings() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }
}

