/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StringAbbreviationDeserializerBase;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TeamscaleIssueIdDeserializer
extends StringAbbreviationDeserializerBase<TeamscaleIssueId> {
    public TeamscaleIssueIdDeserializer(StorageStringAbbreviator stringAbbreviator) {
        super(stringAbbreviator);
    }

    protected Collection<Integer> extractUnAbbreviationIds(byte[] data, int offset) {
        return List.of(Integer.valueOf(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset)));
    }

    public static int getEntryLength(byte[] data, int offset) {
        int internalIdLength = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4));
        int externalIdLength = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4 + 4 + internalIdLength));
        return 8 + internalIdLength + 4 + externalIdLength;
    }

    protected TeamscaleIssueId deserializeFromByteArrayInternal(byte[] data, int offset, Map<Integer, String> unAbbreviationMap) {
        int connectorIdAbbreviation = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset);
        String connectorId = unAbbreviationMap.get(connectorIdAbbreviation);
        int internalIdLength = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4));
        String internalId = StringUtils.bytesToString((byte[])data, (int)(offset + 4 + 4), (int)internalIdLength);
        int externalIdLength = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4 + 4 + internalIdLength));
        String externalId = StringUtils.bytesToString((byte[])data, (int)(offset + 4 + 4 + internalIdLength + 4), (int)externalIdLength);
        return new TeamscaleIssueId(internalId, connectorId, externalId);
    }
}

