/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.base;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class LineBasedStatementRecognizerBase<STATE extends Enum<STATE>>
extends RecognizerBase<STATE> {
    private static final Set<String> TYPESCRIPT_MODIFIERS = new HashSet<String>(Arrays.asList("static", "protected", "public", "private", "readonly"));
    private final Map<ETokenType, ETokenType> nestingMatch = new EnumMap<ETokenType, ETokenType>(ETokenType.class);

    protected LineBasedStatementRecognizerBase() {
        this.registerNestingMatch(ETokenType.LPAREN, ETokenType.RPAREN);
        this.registerNestingMatch(ETokenType.LBRACK, ETokenType.RBRACK);
        this.registerNestingMatch(ETokenType.LBRACE, ETokenType.RBRACE);
    }

    protected final void registerNestingMatch(ETokenType opening, ETokenType closing) {
        this.nestingMatch.put(opening, closing);
    }

    protected boolean isNestedClosingToken(ETokenType token) {
        return this.nestingMatch.containsValue(token);
    }

    @Override
    protected int matchesLocally(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        int nodeStart;
        if (startOffset >= tokens.size()) {
            return -1;
        }
        for (nodeStart = startOffset; nodeStart > 0 && TYPESCRIPT_MODIFIERS.contains(this.getEntityName(tokens, nodeStart - 1)); --nodeStart) {
        }
        this.createNode(parserState, tokens, startOffset);
        return this.processTokens(parserState, tokens, startOffset, nodeStart);
    }

    private int processTokens(ParserState<STATE> parserState, List<IToken> tokens, int startOffset, int nodeStart) {
        IToken lastToken = null;
        Stack<ETokenType> expectedClosing = new Stack<ETokenType>();
        while (startOffset < tokens.size()) {
            IToken token = tokens.get(startOffset);
            ETokenType tokenType = token.getType();
            if (!expectedClosing.isEmpty() && tokenType == expectedClosing.peek()) {
                expectedClosing.pop();
            } else {
                if (expectedClosing.isEmpty() && (this.nestingMatch.containsValue(tokenType) || this.startsNewStatement(token, lastToken))) {
                    return startOffset;
                }
                if (expectedClosing.isEmpty() && ETokenType.SEMICOLON.matches(token)) {
                    return startOffset + 1;
                }
                if (this.tokenStartsSubParse(token, tokens, startOffset, expectedClosing, nodeStart)) {
                    int next = parserState.parse(this.getSubParseState(), tokens, startOffset);
                    if (next == -1) {
                        return -1;
                    }
                    startOffset = next;
                    lastToken = tokens.get(startOffset - 1);
                    continue;
                }
                if (this.nestingMatch.containsKey(tokenType)) {
                    expectedClosing.push(this.nestingMatch.get(tokenType));
                }
            }
            lastToken = token;
            ++startOffset;
        }
        return startOffset;
    }

    private void createNode(ParserState<STATE> parserState, List<IToken> tokens, int startOffset) {
        parserState.setNode(new ShallowEntity(this.getEntityType(), this.getEntitySubtypeName(), this.getEntityName(tokens, startOffset), tokens, parserState.getCurrentMatchStart()));
    }

    protected EShallowEntityType getEntityType() {
        return EShallowEntityType.STATEMENT;
    }

    protected String getEntitySubtypeName() {
        return "simple statement";
    }

    protected String getEntityName(List<IToken> tokens, int startOffset) {
        return tokens.get(startOffset).getText();
    }

    protected abstract STATE getSubParseState();

    protected abstract boolean tokenStartsSubParse(IToken var1, List<IToken> var2, int var3, Stack<ETokenType> var4, int var5);

    protected abstract boolean startsNewStatement(IToken var1, IToken var2);
}

