/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.FileMetadata;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.LanguageDetection;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class InputFileBuilder {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final LanguageDetection langDetection;
    private final FileMetadata fileMetadata;
    private final IssueExclusionsLoader exclusionsScanner;

    public InputFileBuilder(LanguageDetection langDetection, FileMetadata fileMetadata, IssueExclusionsLoader exclusionsScanner) {
        this.langDetection = langDetection;
        this.fileMetadata = fileMetadata;
        this.exclusionsScanner = exclusionsScanner;
    }

    SonarLintInputFile create(ClientInputFile inputFile) {
        SonarLintInputFile defaultInputFile = new SonarLintInputFile(inputFile, f -> {
            InputStream stream;
            LOG.debug("Initializing metadata of file {}", (Object)f.uri());
            Charset charset = f.charset();
            try {
                stream = f.inputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to open a stream on file: " + f.uri(), e);
            }
            return this.fileMetadata.readMetadata(stream, charset != null ? charset : Charset.defaultCharset(), f.uri(), this.exclusionsScanner.createCharHandlerFor((SonarLintInputFile)f));
        });
        defaultInputFile.setType(inputFile.isTest() ? InputFile.Type.TEST : InputFile.Type.MAIN);
        Language fileLanguage = inputFile.language();
        if (fileLanguage != null) {
            LOG.debug("Language of file \"{}\" is set to \"{}\"", (Object)inputFile.uri(), (Object)fileLanguage);
            defaultInputFile.setLanguage(fileLanguage);
        } else {
            defaultInputFile.setLanguage(this.langDetection.language(defaultInputFile));
        }
        return defaultInputFile;
    }
}

