/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ConfigurationBridge;
import org.sonarsource.sonarlint.core.analysis.sonarapi.MultivalueProperty;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.ArrayUtils;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class MapSettings
extends Settings {
    private final Map<String, String> props;
    private final ConfigurationBridge configurationBridge;
    private final PropertyDefinitions definitions;

    public MapSettings(Map<String, String> props) {
        this(new PropertyDefinitions(System2.INSTANCE, new Object[0]), props);
    }

    public MapSettings(PropertyDefinitions definitions, Map<String, String> props) {
        this.props = props.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> definitions.validKey((String)e.getKey()), e -> StringUtils.trim((String)e.getValue())));
        this.definitions = definitions;
        this.configurationBridge = new ConfigurationBridge(this);
    }

    protected Optional<String> get(String key) {
        return Optional.ofNullable(this.props.get(key));
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public Optional<String> getRawString(String key) {
        return this.get(this.definitions.validKey(Objects.requireNonNull(key)));
    }

    public PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    public Optional<PropertyDefinition> getDefinition(String key) {
        return Optional.ofNullable(this.definitions.get(key));
    }

    @Override
    public boolean hasKey(String key) {
        return this.getRawString(key).isPresent();
    }

    @CheckForNull
    public String getDefaultValue(String key) {
        return this.definitions.getDefaultValue(key);
    }

    public boolean hasDefaultValue(String key) {
        return StringUtils.isNotEmpty(this.getDefaultValue(key));
    }

    @Override
    @CheckForNull
    public String getString(String key) {
        String effectiveKey = this.definitions.validKey(key);
        return this.getRawString(effectiveKey).orElseGet(() -> this.getDefaultValue(effectiveKey));
    }

    @Override
    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return StringUtils.isNotEmpty(value) && Boolean.parseBoolean(value);
    }

    @Override
    public int getInt(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public long getLong(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    @Override
    @CheckForNull
    public Date getDate(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return DateUtils.parseDate(value);
        }
        return null;
    }

    @Override
    @CheckForNull
    public Date getDateTime(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return DateUtils.parseDateTime(value);
        }
        return null;
    }

    @Override
    @CheckForNull
    public Float getFloat(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a float value", key));
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public Double getDouble(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a double value", key));
            }
        }
        return null;
    }

    @Override
    public String[] getStringArray(String key) {
        String effectiveKey = this.definitions.validKey(key);
        Optional<PropertyDefinition> def = this.getDefinition(effectiveKey);
        if (def.isPresent() && def.get().multiValues()) {
            String value = this.getString(key);
            if (value == null) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            return MultivalueProperty.parseAsCsv(effectiveKey, value);
        }
        return this.getStringArrayBySeparator(key, ",");
    }

    @Override
    public String[] getStringLines(String key) {
        String value = this.getString(key);
        if (StringUtils.isEmpty(value)) {
            return new String[0];
        }
        return value.split("\r?\n|\r", -1);
    }

    @Override
    public String[] getStringArrayBySeparator(String key, String separator) {
        String value = this.getString(key);
        if (value != null) {
            String[] strings = StringUtils.splitByWholeSeparator(value, separator);
            String[] result = new String[strings.length];
            for (int index = 0; index < strings.length; ++index) {
                result[index] = StringUtils.trim(strings[index]);
            }
            return result;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public List<String> getKeysStartingWith(String prefix) {
        return this.getProperties().keySet().stream().filter(key -> StringUtils.startsWith(key, prefix)).collect(Collectors.toList());
    }

    public Configuration asConfig() {
        return this.configurationBridge;
    }
}

