/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.sonarsource.sonarlint.core.BindingSuggestionProviderImpl;
import org.sonarsource.sonarlint.core.ConfigurationServiceImpl;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.hotspot.HotspotDetailsDto;
import org.sonarsource.sonarlint.core.clientapi.client.hotspot.ShowHotspotParams;
import org.sonarsource.sonarlint.core.clientapi.client.message.MessageType;
import org.sonarsource.sonarlint.core.clientapi.client.message.ShowMessageParams;
import org.sonarsource.sonarlint.core.clientapi.common.TextRangeDto;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.core.embedded.server.ShowHotspotOrIssueRequestHandler;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspotDetails;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

@Named
@Singleton
public class ShowHotspotRequestHandler
extends ShowHotspotOrIssueRequestHandler
implements HttpRequestHandler {
    private final SonarLintClient client;
    private final ConnectionConfigurationRepository repository;
    private final ConfigurationServiceImpl configurationService;
    private final ServerApiProvider serverApiProvider;
    private final TelemetryServiceImpl telemetryService;
    private final ConfigurationRepository configurationRepository;

    public ShowHotspotRequestHandler(SonarLintClient client, ConnectionConfigurationRepository repository, ConfigurationServiceImpl configurationService, BindingSuggestionProviderImpl bindingSuggestionProvider, ServerApiProvider serverApiProvider, TelemetryServiceImpl telemetryService, ConfigurationRepository configurationRepository) {
        super(bindingSuggestionProvider, client);
        this.client = client;
        this.repository = repository;
        this.configurationService = configurationService;
        this.serverApiProvider = serverApiProvider;
        this.telemetryService = telemetryService;
        this.configurationRepository = configurationRepository;
    }

    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        ShowHotspotQuery showHotspotQuery = ShowHotspotRequestHandler.extractQuery(request);
        if (!Method.GET.isSame(request.getMethod()) || !showHotspotQuery.isValid()) {
            response.setCode(400);
            return;
        }
        CompletableFuture.runAsync(() -> this.showHotspot(showHotspotQuery));
        response.setCode(200);
        response.setEntity((HttpEntity)new StringEntity("OK"));
    }

    private void showHotspot(ShowHotspotQuery query) {
        this.telemetryService.showHotspotRequestReceived();
        List<AbstractConnectionConfiguration> connectionsMatchingOrigin = this.repository.findByUrl(query.serverUrl);
        if (connectionsMatchingOrigin.isEmpty()) {
            this.startFullBindingProcess();
            ((CompletableFuture)((CompletableFuture)this.assistCreatingConnection(query.serverUrl).thenCompose(response -> this.assistBinding(response.getConfigScopeIds(), response.getNewConnectionId(), query.projectKey))).thenAccept(response -> {
                if (response.getConfigurationScopeId() != null) {
                    this.showHotspotForScope(response.getConnectionId(), response.getConfigurationScopeId(), query.hotspotKey);
                }
            })).whenComplete((v, e) -> this.endFullBindingProcess());
        } else {
            Set<String> configScopeIds = this.configurationRepository.getConfigScopeIds();
            this.showHotspotForConnection(configScopeIds, connectionsMatchingOrigin.get(0).getConnectionId(), query.projectKey, query.hotspotKey);
        }
    }

    private void showHotspotForConnection(Set<String> configScopeIds, String connectionId, String projectKey, String hotspotKey) {
        List<ConfigurationScope> scopes = this.configurationService.getConfigScopesWithBindingConfiguredTo(connectionId, projectKey);
        if (scopes.isEmpty()) {
            this.assistBinding(configScopeIds, connectionId, projectKey).thenAccept(newBinding -> {
                if (newBinding.getConfigurationScopeId() != null) {
                    this.showHotspotForScope(connectionId, newBinding.getConfigurationScopeId(), hotspotKey);
                }
            });
        } else {
            ConfigurationScope firstBoundScope = scopes.get(0);
            this.showHotspotForScope(connectionId, firstBoundScope.getId(), hotspotKey);
        }
    }

    private void showHotspotForScope(String connectionId, String configurationScopeId, String hotspotKey) {
        this.tryFetchHotspot(connectionId, hotspotKey).ifPresentOrElse(hotspot -> this.client.showHotspot(new ShowHotspotParams(configurationScopeId, ShowHotspotRequestHandler.adapt(hotspotKey, hotspot))), () -> this.client.showMessage(new ShowMessageParams(MessageType.ERROR, "Could not show the hotspot. See logs for more details")));
    }

    private Optional<ServerHotspotDetails> tryFetchHotspot(String connectionId, String hotspotKey) {
        Optional<ServerApi> serverApi = this.serverApiProvider.getServerApi(connectionId);
        if (serverApi.isEmpty()) {
            return Optional.empty();
        }
        return serverApi.get().hotspot().fetch(hotspotKey);
    }

    private static HotspotDetailsDto adapt(String hotspotKey, ServerHotspotDetails hotspot) {
        return new HotspotDetailsDto(hotspotKey, hotspot.message, hotspot.filePath, ShowHotspotRequestHandler.adapt(hotspot.textRange), hotspot.author, hotspot.status.toString(), hotspot.resolution != null ? hotspot.resolution.toString() : null, ShowHotspotRequestHandler.adapt(hotspot.rule), hotspot.codeSnippet);
    }

    private static HotspotDetailsDto.HotspotRule adapt(ServerHotspotDetails.Rule rule) {
        return new HotspotDetailsDto.HotspotRule(rule.key, rule.name, rule.securityCategory, rule.vulnerabilityProbability.toString(), rule.riskDescription, rule.vulnerabilityDescription, rule.fixRecommendations);
    }

    private static TextRangeDto adapt(TextRange textRange) {
        return new TextRangeDto(textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset());
    }

    private static ShowHotspotQuery extractQuery(ClassicHttpRequest request) {
        HashMap params = new HashMap();
        try {
            new URIBuilder(request.getUri(), StandardCharsets.UTF_8).getQueryParams().forEach(p -> params.put(p.getName(), p.getValue()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new ShowHotspotQuery((String)params.get("server"), (String)params.get("project"), (String)params.get("hotspot"));
    }

    private static class ShowHotspotQuery {
        private final String serverUrl;
        private final String projectKey;
        private final String hotspotKey;

        private ShowHotspotQuery(String serverUrl, String projectKey, String hotspotKey) {
            this.serverUrl = serverUrl;
            this.projectKey = projectKey;
            this.hotspotKey = hotspotKey;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank(this.serverUrl) && StringUtils.isNotBlank(this.projectKey) && StringUtils.isNotBlank(this.hotspotKey);
        }
    }
}

