/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.progress;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.progress.ProgressEndNotification;
import org.sonarsource.sonarlint.core.clientapi.client.progress.ReportProgressParams;
import org.sonarsource.sonarlint.core.clientapi.client.progress.StartProgressParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.progress.ClientProgressNotifier;
import org.sonarsource.sonarlint.core.progress.NoOpProgressNotifier;
import org.sonarsource.sonarlint.core.progress.ProgressNotifier;

public class TaskManager {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SonarLintClient client;

    public TaskManager(SonarLintClient client) {
        this.client = client;
    }

    public CompletableFuture<Void> startTask(@Nullable String configurationScopeId, String title, @Nullable String message, boolean indeterminate, boolean cancellable, Consumer<ProgressNotifier> task) {
        UUID taskId = UUID.randomUUID();
        return ((CompletableFuture)this.client.startProgress(new StartProgressParams(taskId.toString(), configurationScopeId, title, message, indeterminate, cancellable)).thenAccept(nothing -> {
            try {
                task.accept(new ClientProgressNotifier(this.client, taskId));
            }
            catch (Exception e) {
                LOG.error("Error running task '" + title + "'", e);
            }
            finally {
                this.client.reportProgress(new ReportProgressParams(taskId.toString(), new ProgressEndNotification()));
            }
        })).exceptionally(error -> {
            LOG.error("The client was unable to start progress, cause:", (Throwable)error);
            try {
                task.accept(new NoOpProgressNotifier());
            }
            catch (Exception e) {
                LOG.error("Error running task '" + title + "'", e);
            }
            return null;
        });
    }
}

