/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SimulinkBusElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dataType;
    private final Pair<Integer, Integer> dimensions;
    private final String rawDimensions;
    private final String rawDimensionsMode;

    public SimulinkBusElement(String name, String dataType, Pair<Integer, Integer> parsedDimensions, String rawDimensions, String rawDimensionsMode) {
        this.name = name;
        this.dataType = dataType;
        this.dimensions = parsedDimensions;
        this.rawDimensions = rawDimensions;
        this.rawDimensionsMode = rawDimensionsMode;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Pair<Integer, Integer> getDimensions() {
        return this.dimensions;
    }

    public String getRawDimensions() {
        return this.rawDimensions;
    }

    public String getRawDimensionsMode() {
        return this.rawDimensionsMode;
    }

    public boolean equals(Object busElement) {
        if (busElement instanceof SimulinkBusElement) {
            String busName2;
            SimulinkBusElement element = (SimulinkBusElement)busElement;
            String busName1 = this.name.replaceAll("[()]", "");
            return busName1.endsWith(busName2 = element.getName().replaceAll("[()]", "")) || busName2.endsWith(busName1);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(StringUtils.getLastPart((String)this.name, (String)"."), this.dataType);
    }
}

