/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=CommitDescriptor.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CommitDescriptor.class, name="simple"), @JsonSubTypes.Type(value=ParentedCommitDescriptor.class, name="parented")})
@IndexValueClass(containedInBackup=true)
public class CommitDescriptor
implements Serializable,
Comparable<CommitDescriptor> {
    public static final byte[] SEPARATOR = new byte[]{1, 2, 1};
    private static final String NO_BRANCH_NAME = "##no-branch##";
    private static final long serialVersionUID = 1L;
    public static final String HEAD_TIMESTAMP = "HEAD";
    public static final Comparator<CommitDescriptor> BY_TIMESTAMP_COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(CommitDescriptor::getTimestamp).thenComparing(CommitDescriptor::getBranchName));
    protected static final String BRANCH_NAME_PROPERTY = "branchName";
    protected static final String TIMESTAMP_PROPERTY = "timestamp";
    @JsonProperty(value="branchName")
    private final @NonNull String branchName;
    @JsonProperty(value="timestamp")
    private final long timestamp;

    @JsonCreator
    public CommitDescriptor(@JsonProperty(value="branchName") @NonNull String branchName, @JsonProperty(value="timestamp") long timestamp) {
        CCSMAssert.isTrue((timestamp >= 0L ? 1 : 0) != 0, () -> "Timestamp must be >= 0 but is " + timestamp);
        CCSMAssert.isNotNull((Object)branchName);
        this.branchName = branchName;
        this.timestamp = timestamp;
    }

    public CommitDescriptor(CommitDescriptor other) {
        this(other.branchName, other.timestamp);
    }

    public static CommitDescriptor createUnbranchedDescriptor(long timestamp) {
        return new CommitDescriptor(NO_BRANCH_NAME, timestamp);
    }

    public CommitDescriptor cloneWithDecrementedTimestamp() {
        return new CommitDescriptor(this.branchName, this.timestamp - 1L);
    }

    public CommitDescriptor cloneWithIncrementedTimestamp() {
        return new CommitDescriptor(this.branchName, this.timestamp + 1L);
    }

    public @NonNull String getBranchName() {
        return this.branchName;
    }

    public boolean isUnbranched() {
        return NO_BRANCH_NAME.equals(this.branchName);
    }

    public boolean isHeadCommit() {
        return this.timestamp == Long.MAX_VALUE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommitDescriptor) {
            CommitDescriptor other = (CommitDescriptor)obj;
            return other.timestamp == this.timestamp && Objects.equals(this.branchName, other.branchName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.branchName) ^ Long.hashCode(this.timestamp);
    }

    @Override
    public int compareTo(CommitDescriptor other) {
        if (this.timestamp == other.timestamp) {
            return this.branchName.compareTo(other.branchName);
        }
        return Long.compare(this.timestamp, other.timestamp);
    }

    public static CommitDescriptor max(CommitDescriptor c1, CommitDescriptor c2) {
        return c1.compareTo(c2) > 0 ? c1 : c2;
    }

    public String toJson() {
        return JsonUtils.serializeToJSON(this);
    }

    public static CommitDescriptor fromJson(String json) throws ConQATException {
        return JsonUtils.deserializeFromJsonWithNullCheck(json, CommitDescriptor.class);
    }

    public String toString() {
        return this.branchName + "@" + this.timestamp;
    }

    public byte[] toTimestampBranchKey() {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.longToByteArray((long)this.getTimestamp()), StringUtils.stringToBytes((String)this.getBranchName())});
    }

    public static CommitDescriptor fromStringRepresentation(String representation) {
        int separatorPosition = representation.lastIndexOf("@");
        CCSMAssert.isTrue((separatorPosition >= 0 ? 1 : 0) != 0, () -> "Invalid string representation of commit descriptor: " + representation);
        String branch = representation.substring(0, separatorPosition);
        String timestamp = representation.substring(separatorPosition + 1);
        return new CommitDescriptor(branch, Long.parseLong(timestamp));
    }

    public static CommitDescriptor fromTimestampBranchKey(byte[] key) {
        long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOf(key, 8));
        String branchName = StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, 8, key.length));
        return new CommitDescriptor(branchName, timestamp);
    }

    public byte[] toBranchTimestampKey() {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)this.getBranchName()), ByteArrayUtils.longToByteArray((long)this.getTimestamp())});
    }

    public byte[] toBranchTimestampKeyWithSeparator() {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)this.getBranchName()), SEPARATOR, ByteArrayUtils.longToByteArray((long)this.getTimestamp())});
    }

    public static CommitDescriptor fromBranchTimestampKeyWithSeparator(byte[] key) {
        String branchName = StringUtils.bytesToString((byte[])Arrays.copyOf(key, key.length - 8 - SEPARATOR.length));
        long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, key.length - 8, key.length));
        return new CommitDescriptor(branchName, timestamp);
    }

    public static CommitDescriptor fromBranchTimestampKey(byte[] key) {
        String branchName = StringUtils.bytesToString((byte[])Arrays.copyOf(key, key.length - 8));
        long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, key.length - 8, key.length));
        return new CommitDescriptor(branchName, timestamp);
    }

    public static CommitDescriptor latestOnBranch(String branchName) {
        return new CommitDescriptor(branchName, Long.MAX_VALUE);
    }

    public String toServiceCallFormat() {
        Object result = this.branchName + ":";
        if (NO_BRANCH_NAME.equals(this.branchName)) {
            result = "";
        }
        if (this.timestamp == Long.MAX_VALUE) {
            return (String)result + HEAD_TIMESTAMP;
        }
        return (String)result + this.timestamp;
    }

    public static CommitDescriptor fromServiceCallFormat(String representation) {
        int separatorPosition = representation.lastIndexOf(":");
        String branchName = separatorPosition > 0 ? representation.substring(0, separatorPosition) : NO_BRANCH_NAME;
        String timestampPart = representation.substring(separatorPosition + 1);
        long timestamp = HEAD_TIMESTAMP.equals(timestampPart) ? Long.MAX_VALUE : Long.parseLong(timestampPart);
        return new CommitDescriptor(branchName, timestamp);
    }

    public String toEncodedQueryParam() {
        return UrlUtils.encodeQueryParameter((String)this.toServiceCallFormat());
    }

    public String toEncodedPathParam() {
        return UrlUtils.encodePathSegment((String)this.toServiceCallFormat());
    }

    public UnresolvedCommitDescriptor toUnresolvedCommitDescriptor() {
        return new UnresolvedCommitDescriptor(this.getBranchName(), this.getTimestamp());
    }
}

