/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchInterface;

public abstract class AbstractWriteBatch
extends RocksObject
implements WriteBatchInterface {
    protected AbstractWriteBatch(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    public int count() {
        return this.count0(this.nativeHandle_);
    }

    @Override
    public void put(byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, key, key.length, value, value.length);
    }

    @Override
    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.put(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_);
    }

    @Override
    public void merge(byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, key, key.length, value, value.length);
    }

    @Override
    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) throws RocksDBException {
        this.merge(this.nativeHandle_, key, key.length, value, value.length, columnFamilyHandle.nativeHandle_);
    }

    @Override
    public void put(ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        this.putDirect(this.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), 0L);
        key.position(key.limit());
        value.position(value.limit());
    }

    @Override
    public void put(ColumnFamilyHandle columnFamilyHandle, ByteBuffer key, ByteBuffer value) throws RocksDBException {
        assert (key.isDirect() && value.isDirect());
        this.putDirect(this.nativeHandle_, key, key.position(), key.remaining(), value, value.position(), value.remaining(), columnFamilyHandle.nativeHandle_);
        key.position(key.limit());
        value.position(value.limit());
    }

    @Override
    public void delete(byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, key, key.length);
    }

    @Override
    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.delete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    @Override
    public void delete(ByteBuffer key) throws RocksDBException {
        this.deleteDirect(this.nativeHandle_, key, key.position(), key.remaining(), 0L);
        key.position(key.limit());
    }

    @Override
    public void delete(ColumnFamilyHandle columnFamilyHandle, ByteBuffer key) throws RocksDBException {
        this.deleteDirect(this.nativeHandle_, key, key.position(), key.remaining(), columnFamilyHandle.nativeHandle_);
        key.position(key.limit());
    }

    @Override
    public void singleDelete(byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, key, key.length);
    }

    @Override
    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] key) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, key, key.length, columnFamilyHandle.nativeHandle_);
    }

    @Override
    public void deleteRange(byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, beginKey, beginKey.length, endKey, endKey.length);
    }

    @Override
    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, byte[] beginKey, byte[] endKey) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, beginKey, beginKey.length, endKey, endKey.length, columnFamilyHandle.nativeHandle_);
    }

    @Override
    public void putLogData(byte[] blob) throws RocksDBException {
        this.putLogData(this.nativeHandle_, blob, blob.length);
    }

    @Override
    public void clear() {
        this.clear0(this.nativeHandle_);
    }

    @Override
    public void setSavePoint() {
        this.setSavePoint0(this.nativeHandle_);
    }

    @Override
    public void rollbackToSavePoint() throws RocksDBException {
        this.rollbackToSavePoint0(this.nativeHandle_);
    }

    @Override
    public void popSavePoint() throws RocksDBException {
        this.popSavePoint(this.nativeHandle_);
    }

    @Override
    public void setMaxBytes(long maxBytes) {
        this.setMaxBytes(this.nativeHandle_, maxBytes);
    }

    @Override
    public WriteBatch getWriteBatch() {
        return this.getWriteBatch(this.nativeHandle_);
    }

    abstract int count0(long var1);

    abstract void put(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    abstract void put(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    abstract void putDirect(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8, long var9) throws RocksDBException;

    abstract void merge(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    abstract void merge(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    abstract void delete(long var1, byte[] var3, int var4) throws RocksDBException;

    abstract void delete(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    abstract void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    abstract void singleDelete(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    abstract void deleteDirect(long var1, ByteBuffer var3, int var4, int var5, long var6) throws RocksDBException;

    abstract void deleteRange(long var1, byte[] var3, int var4, byte[] var5, int var6) throws RocksDBException;

    abstract void deleteRange(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7) throws RocksDBException;

    abstract void putLogData(long var1, byte[] var3, int var4) throws RocksDBException;

    abstract void clear0(long var1);

    abstract void setSavePoint0(long var1);

    abstract void rollbackToSavePoint0(long var1);

    abstract void popSavePoint(long var1) throws RocksDBException;

    abstract void setMaxBytes(long var1, long var3);

    abstract WriteBatch getWriteBatch(long var1);
}

