# Description
Checks alignment within statements which span multiple lines.

# Extended Information
Lines following the first line should be indented once (2 spaces).

For block declaration statements, lines after the first should be indented an additional time (default: +2 spaces)
to distinguish them better from code within the block.

# Examples
**Bad example**
```abap
IF 1 = 1
  AND 2 = 2.
  WRITE 'hello' &&
  'world'.
ENDIF.
```

**Good example**
```abap
IF 1 = 1
    AND 2 = 2.
  WRITE 'hello' &&
    'world'.
ENDIF.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/in_statement_indentation) <br>
