This plugin test checks for the unsafe usage of the
``logging.config.listen`` function. The logging.config.listen
function provides the ability to listen for external
configuration files on a socket server. Because portions of the
configuration are passed through eval(), use of this function
may open its users to a security risk. While the function only
binds to a socket on localhost, and so does not accept connections
from remote machines, there are scenarios where untrusted code
could be run under the account of the process which calls listen().

logging.config.listen provides the ability to verify bytes received
across the socket with signature verification or encryption/decryption.

## Example


In the following code snippet the issue is: [B612:logging_config_listen] Use of insecure
logging.config.listen detected.
For more information on this see: CWE-94 (https://cwe.mitre.org/data/definitions/94.html)
``` python

t = logging.config.listen(9999)
```
## see also:

- https://docs.python.org/3/library/logging.config.html#logging.config.listen

New in version  1.7.5
