A object should be be compared to a type by using `isinstance`. This is because `isinstance` can handle subclasses as well.

### Anti-pattern

The below example will not handle a potential future case where `user` is a subclass or `User`.

```python
if type(user) == User:
    print(user.name)
```

### Best practice

```python
if isinstance(user, User):
    print(user.name)
```
