<p>When a cookie is protected with the <code>secure</code> attribute set to <em>true</em> it will not be send by the browser over an unencrypted HTTP
request and thus cannot be observed by an unauthorized person during a man-in-the-middle attack.</p>
<h2>Ask Yourself Whether</h2>
<ul>
  <li> the cookie is for instance a <em>session-cookie</em> not designed to be sent over non-HTTPS communication. </li>
  <li> it’s not sure that the website contains <a href="https://developer.mozilla.org/en-US/docs/Web/Security/Mixed_content">mixed content</a> or not
  (ie HTTPS everywhere or not) </li>
</ul>
<p>There is a risk if you answered yes to any of those questions.</p>
<h2>Recommended Secure Coding Practices</h2>
<ul>
  <li> It is recommended to use <code>HTTPs</code> everywhere so setting the <code>secure</code> flag to <em>true</em> should be the default behaviour
  when creating cookies. </li>
  <li> Set the <code>secure</code> flag to <em>true</em> for session-cookies. </li>
</ul>
<h2>Sensitive Code Example</h2>
<p>When the <code>HttpCookie.Secure</code> property is set to <code>false</code> then the cookie will be send during an unencrypted HTTP request:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
myCookie.Secure = false; //  Sensitive: a security-sensitive cookie is created with the secure flag set to false
</pre>
<p>The <a href="https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie.secure?view=netframework-4.8">default value</a> of
<code>Secure</code> flag is <code>false</code>, unless overwritten by an application’s configuration file:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
//  Sensitive: a security-sensitive cookie is created with the secure flag not defined (by default set to false)
</pre>
<h2>Compliant Solution</h2>
<p>Set the <code>HttpCookie.Secure</code> property to <code>true</code>:</p>
<pre>
HttpCookie myCookie = new HttpCookie("Sensitive cookie");
myCookie.Secure = true; // Compliant
</pre>
<p>Or change the default flag values for the whole application by editing the <a
href="https://docs.microsoft.com/en-us/previous-versions/dotnet/netframework-4.0/ms228262(v=vs.100)">Web.config configuration file</a>:</p>
<pre>
&lt;httpCookies httpOnlyCookies="true" requireSSL="true" /&gt;
</pre>
<ul>
  <li> the <code>requireSSL</code> attribute corresponds programmatically to the <code>Secure</code> field. </li>
  <li> the <code>httpOnlyCookies</code> attribute corresponds programmatically to the <code>httpOnly</code> field. </li>
</ul>
<h2>See</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A04_2021-Insecure_Design/">Top 10 2021 Category A4 - Insecure Design</a> </li>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure">Top 10 2017 Category A3 - Sensitive Data
  Exposure</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/311">CWE-311 - Missing Encryption of Sensitive Data</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/315">CWE-315 - Cleartext Storage of Sensitive Information in a Cookie</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/614">CWE-614 - Sensitive Cookie in HTTPS Session Without 'Secure' Attribute</a> </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222576">Application Security and
  Development: V-222576</a> - The application must set the secure flag on session cookies. </li>
</ul>

